% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topodb_download.R
\name{topodb_download}
\alias{topodb_download}
\title{downloads Topographic Databases for counties}
\usage{
topodb_download(county = NULL, TERYT = NULL, outdir = ".", unzip = TRUE, ...)
}
\arguments{
\item{county}{county name in Polish. Check \code{\link[=county_names]{county_names()}} function.}

\item{TERYT}{county ID (4 characters)}

\item{outdir}{(optional) name of the output directory;
by default, files are saved in the working directory}

\item{unzip}{TRUE (default) or FALSE, when TRUE the downloaded archive will
be extracted and removed}

\item{...}{additional argument for \code{\link[utils:download.file]{utils::download.file()}}}
}
\value{
a database in Geography Markup Language format (.GML),
the content and detail level corresponds to the topographic map
in the scale of 1:10000
}
\description{
downloads Topographic Databases for counties
}
\examples{
\dontrun{
topodb_download(county = "Świętochłowice") # 2.4 MB
topodb_download(TERYT = c("2476", "2264")) # 4.8 MB
}
}
\references{
description of topographical and general geographical databases,
and technical standards for making maps (in Polish):
\url{http://www.gugik.gov.pl/__data/assets/pdf_file/0005/208661/rozp_BDOT10k_BDOO.pdf}

brief description of categories and layer names (in English and Polish):
\url{https://kadyb.github.io/rgugik/articles/articles/spatialdb_description.html}
}
