\name{kola.c}
\docType{data}
\alias{kola.c}
\title{ Kola Project C-horizon Soil Data }
\description{
These data arise from an ecogeochemical survey undertaken by the Central Kola Expedition of Russia (CKE), the Geological Survey of Finland (GTK) and the Norwegian Geological Survey (NGU).  In 1995 a variety of soil and biological materials were collected from almost 700 sites lying between the Arctic Circle and the Barents Sea, and Longitudes 35.5 and 40.0 East.  This specific data set is for C-horizon soils found at 606 of the sites visited.  The data consist of an integer identifier, Universal Transverse Mercator (m) eastings and northings coordinates, the country the site was located in as a 3 character string, the lithology of the underlying bedrock as an integer code, 36 chemical measurements (total or near-total geochemical analyses), and soil pH for the \code{<2} mm fraction of the C-horizon soils.  The data reflect the natural geochemical variations in the parent material of the overlying soils.  Further details concerning the project, methods of sampling and analysis can be found in Reimann et al. (1998) and the numerous papers published by the co-authors in international scientific journals.
}
\usage{kola.c}
\source{
These data are a subset of the full Kola C-horizon data set available from:
\url{http://doi.pangaea.de/10.1594/PANGAEA.56227}

However, it should be noted that the spatial coordinates are recorded as Latitudes and Longitudes in the full data set.
}
\format{ A data frame containing 44 observations for 617 sites. }
\references{
Reimann, C., Ayras, M., Chekushin, V., Bogatyrev, I., Boyd, R., de Caritat, P., Dutter, R., Finne, T.E., Halleraker, J.H., Jager, O., Kashulina, G., Niskavaara, H., Pavlov, V., Raisanen, M.L., Strand, T. and Volden, T., 1998. A geochemical atlas of the central parts of the Barents Region. Geological Survey of Norway (NGU), Trondheim, Norway. ISBN 82-7385-176-1. 745 p.
}
\keyword{ datasets }

