% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_download_get.r
\name{occ_download_get}
\alias{occ_download_get}
\title{Get a download from GBIF.}
\usage{
occ_download_get(key, path = ".", overwrite = FALSE, curlopts = list())
}
\arguments{
\item{key}{A key generated from a request, like that from \code{occ_download}}

\item{path}{Path to write zip file to. Default: \code{"."}, with a
\code{.zip} appended to the end.}

\item{overwrite}{Will only overwrite existing path if TRUE.}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\description{
Get a download from GBIF.
}
\details{
Downloads the zip file to a directory you specify on your machine.
\code{\link[crul:HttpClient]{crul::HttpClient()}} is used internally to write the zip file to
disk. See \link[crul:writing-options]{crul::writing-options}. This function only downloads the file.
See \code{occ_download_import} to open a downloaded file in your R session.
The speed of this function is of course proportional to the size of the
file to download. For example, a 58 MB file on my machine took about
26 seconds.
}
\note{
see \link{downloads} for an overview of GBIF downloads methods
}
\examples{
\dontrun{
occ_download_get("0000066-140928181241064")
occ_download_get("0003983-140910143529206", overwrite = TRUE)
}
}
