% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frenamevector.R
\name{f_rename_vector}
\alias{f_rename_vector}
\title{Rename Elements of a Vector Based on a Mapping}
\usage{
f_rename_vector(vector, name_map)
}
\arguments{
\item{vector}{A character vector containing the elements to be renamed.}

\item{name_map}{A named vector where the names correspond to the elements in \code{vector} that should be renamed, and the values are the new names to assign.}
}
\value{
A character vector with updated element names. Elements not found in \code{name_map} remain unchanged.
}
\description{
Renames elements of a vector based on a named mapping vector. Elements that match the names in the mapping vector are replaced with their corresponding values, while elements not found in the mapping remain unchanged.
}
\details{
This function iterates through each element of \code{vector} and checks if it exists in the names of \code{name_map}. If a match is found, the element is replaced with the corresponding value from \code{name_map}. If no match is found, the original element is retained. The result is returned as an unnamed character vector.
}
\examples{
# Define a vector and a name map.
vector   <- c("Species", "Weight", "L")
name_map <- c(Species = "New_species_name", L = "Length_cm")

# Rename elements of the vector.
updated_vector <- f_rename_vector(vector, name_map)

# View updated vector
print(updated_vector)

}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
