% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fclear.R
\name{f_clear}
\alias{f_clear}
\title{f_clear: Clear Various Aspects of the R Environment}
\usage{
f_clear(env = TRUE, gc = TRUE, console = TRUE, graph = TRUE, restart = FALSE)
}
\arguments{
\item{env}{Logical. If \code{TRUE}, all objects in the global environment are removed. Default is \code{TRUE}.}

\item{gc}{Logical. If \code{TRUE}, garbage collection is performed to free up memory. Default is \code{TRUE}.}

\item{console}{Logical. If \code{TRUE}, the R console is cleared. Default is \code{TRUE}.}

\item{graph}{Logical. If \code{TRUE}, all open graphics devices are closed. Default is \code{TRUE}.}

\item{restart}{Logical. If \code{TRUE}, the R session is restarted using 'RStudio's' API. Default is \code{FALSE}.}
}
\value{
No return value, called for side effects, see details.
}
\description{
Provides a convenient way to clear different components of the R environment, including the console, memory, graphics, and more. It also offers the option to restart the R session. This can come in handy at the start of an R script.
}
\details{
\itemize{
\item Console Clearing: Clears the console output.
\item Garbage Collection: Performs garbage collection to free memory from unreferenced objects.
\item Graph Clearing: Closes all open graphics devices.
\item Environment Clearing: Removes all objects from the global environment.
\item Session Restart: Restarts the R session (only available in 'RStudio').
}
}
\note{
The \code{restart} parameter requires 'RStudio' and its API package ('rstudioapi') to be installed and available.
}
\examples{
# Clear console, memory, graphs, and for example NOT the environment.
f_clear(env = FALSE)


}
\author{
Sander H. van Delden  \email{plantmind@proton.me} \cr
}
