% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rf.regression.fit.R
\name{rf.regression.fit}
\alias{rf.regression.fit}
\title{Random Forest fit statistics}
\usage{
rf.regression.fit(x)
}
\arguments{
\item{x}{randomForest regression object}
}
\value{
A list and rf.fit class object with "fit" matrix of fit statistics and "message" indicating overfit risk.
}
\description{
Evaluatues fit and overfit of random forests regression
}
\examples{
  library(randomForest)
  set.seed(131)
  data(airquality)
  airquality <- na.omit(airquality)
  ( rf.aq <- randomForest(airquality[,1:3], airquality[,"Ozone"]) )	
  rf.regression.fit(rf.aq)

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}

