% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_raw_data_files.R
\name{get_raw_data_files}
\alias{get_raw_data_files}
\title{Get Raw Data Files}
\usage{
get_raw_data_files(rev_product_ids, rev_session_id, rev_username)
}
\arguments{
\item{rev_product_ids}{A vector of Revenera product id's for which
you want active user data.}

\item{rev_session_id}{Session ID established by the connection to
Revenera API. This can be obtained with revenera_auth().}

\item{rev_username}{Revenera username.}
}
\value{
Data frame with available files and URLs.
}
\description{
Retrieves a list of raw data file exports that are available for a
list of product IDs and the download URL for each file.
}
\details{
Raw data files are an add-on service available through Revenera. If
these files are available they can be downloaded manually from the
user portal, or downloaded via R. This function uses the API to
first retrieve the list of files, and then get the download URL for
each file.

It is not recommended that your username be stored directly in your
code. There are various methods and packages available that are more
secure; this package does not require you to use any one in particular.
}
\examples{
\dontrun{
rev_user <- "my_username"
rev_pwd <- "super_secret"
product_ids_list <- c("123", "456", "789")
session_id <- revenera_auth(rev_user, rev_pwd)
files_df <- get_raw_data_files(product_ids_list, session_id, rev_user)
file_list <- dplyr::pull(files_df, var = file_name)
for (f in file_list) {
  url <- dplyr::filter(files_df, file_name == f) \%>\%
    dplyr::pull(download_url)
  download.file(url, mode = "wb", destfile = "download_file_location.zip")
}
}
}
