% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spheristruct.R
\name{flipped.triangles}
\alias{flipped.triangles}
\title{Determine indices of triangles that are flipped}
\usage{
flipped.triangles(Ps, Tt, R = 1)
}
\arguments{
\item{Ps}{N-by-2 matrix with columns containing latitudes
(\code{phi}) and longitudes (\code{lambda}) of N points}

\item{Tt}{Triangulation of points}

\item{R}{Radius of sphere}
}
\value{
List containing:
\item{\code{flipped}}{Indices of in rows of \code{Tt} of flipped triangles.}
\item{\code{cents}}{Vectors of centres.}
\item{\code{areas}}{Areas of triangles.}
}
\description{
In the projection of points onto the sphere, some triangles maybe
flipped, i.e. in the wrong orientation.  This functions determines
which triangles are flipped by computing the vector pointing to
the centre of each triangle and comparing this direction to vector
product of two sides of the triangle.
}
\author{
David Sterratt
}
