% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TriangulatedFragment.R
\docType{data}
\name{TriangulatedFragment}
\alias{TriangulatedFragment}
\title{Triangulate outline

Parameters to constructor:
\code{P} Points to triangulate
\code{n} Minimum number of points in the triangulation
\code{suppress.external.steiner} If \code{TRUE} prevent the
addition of points in the outline. This happens to maintain
triangle quality.
\code{report} Function to report progress}
\format{An object of class \code{R6ClassGenerator} of length 24.}
\usage{
TriangulatedFragment
}
\value{
A \code{triangulatedFragment} object containing the
following fields:
\item{\code{P}}{The set of new points, with the existing points at the start}
\item{\code{T}}{The triangulation}
\item{\code{Cu}}{Unique set of M connections, as M*2 matrix}
\item{\code{h}}{Correspondences mapping}
\item{\code{A}}{Array containing area of each triangle}
\item{\code{L}}{Length of each connection}
\item{\code{A.signed}}{Signed area of each triangle}
\item{\code{A.tot}}{Total area of outline}
\item{\code{gf}}{Forward pointers}
\item{\code{gb}}{Backward pointers}
\item{\code{S}}{Segments (from \code{\link{triangulate}})}
\item{\code{E}}{Edges (from \code{\link{triangulate}})}
\item{\code{EB}}{Edge boundaries (from \code{\link{triangulate}})}
}
\description{
Create a triangulation of the \code{Fragment} object \code{o}.  The
minimum number of triangles in the triangulation is specified by
\code{n}.
}
\author{
David Sterratt
}
\keyword{datasets}
