% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gb-get-tools.R
\name{gb_fasta_get}
\alias{gb_fasta_get}
\title{Get fasta from GenBank}
\usage{
gb_fasta_get(id, width = 70)
}
\arguments{
\item{id}{character, sequence accession ID(s)}

\item{width}{integer, maximum number of characters in a line}
}
\value{
named vector of fasta sequences, if no results found NULL
}
\description{
Get sequence and definition data in FASTA format. Equivalent to
\code{rettype='fasta'} in \code{\link[rentrez:entrez_fetch]{rentrez::entrez_fetch()}}.
}
\examples{
library(restez)
restez_path_set(filepath = tempdir())
demo_db_create(n = 5)
(fasta <- gb_fasta_get(id = 'demo_1'))
(fastas <- gb_fasta_get(id = c('demo_1', 'demo_2')))


# delete demo after example
db_delete(everything = TRUE)
}
\seealso{
\code{\link[=ncbi_acc_get]{ncbi_acc_get()}}

Other get: 
\code{\link{gb_definition_get}()},
\code{\link{gb_organism_get}()},
\code{\link{gb_record_get}()},
\code{\link{gb_sequence_get}()},
\code{\link{gb_version_get}()}
}
\concept{get}
