% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_nh4.R
\encoding{UTF-8}
\name{conv_nh4}
\alias{conv_nh4}
\title{Convert between units of ammonia (NH3) / ammonium (NH4+)}
\usage{
conv_nh4(n_waste, from = "umol_NH4", to = "all")
}
\arguments{
\item{n_waste}{a numeric vector of the ammonia or nitrogen value(s).}

\item{from}{a string describing the unit used to measure \code{n_waste}. Default is "umol_NH4" Options are:\itemize{
\item{umol_NH3}{}
\item{umol_NH4}{}
\item{mg_NH3}{}
\item{mg_NH4}{}
\item{mg_N}{}
}}

\item{to}{a single string either describing the unit to which the conversion should be conducted (options are the same as in \code{from}), or the string "all" to return all units.}
}
\description{
Ammonia or nitrogen excretion can be measured in a variety of ways. Convert between different measurements.
}
\details{
The sum of NH4+ and NH3 species are considered (i.e. TAN). Conversions are based on relationships and values from the package \code{\link[marelac]{marelac}}.
}
\examples{
conv_nh4(n_waste = 100)
conv_nh4(n_waste = 100, from = 'mg_N')
conv_nh4(n_waste = 100, from = 'mg_N', to = 'umol_NH4')

}
\seealso{
\code{\link{predict_nh3}}, \code{\link{conv_o2}}
}
\author{
Matthew A. Birk, \email{matthewabirk@gmail.com}
}
