% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_lin.R
\name{test_lin}
\alias{test_lin}
\title{Perform \code{auto_rate()} iteratively and extract performance metrics}
\usage{
test_lin(
  reps = 1,
  len = 300,
  sd = 0.05,
  type = "default",
  preview = FALSE,
  plot = FALSE
)
}
\arguments{
\item{reps}{numeric. Number of times to iterate \code{auto_rate()} on a randomly
generated dataset. Defaults to 1.}

\item{len}{numeric. Length (number of observations) of the dataset to test
\code{auto_rate()} on. Defaults to 300.}

\item{sd}{numeric. Noise to add to the data. Defaults to .05 standard
difference.}

\item{type}{character. Use "default", "corrupted" or "segmented" to pick one
of the three different kinds of data to generate.}

\item{preview}{logical. This will show the randomly-generated data in your
plot window at every iteration. \strong{Note: will slow the function down.}
Useful to see the shape of the data. Defaults to FALSE.}

\item{plot}{logical. This will show the diagnostic plots of \code{auto_rate()} at
every iteration. \strong{Note: will severely slow the function down.} Useful to
visualise what's being detected at every step. Defaults to FALSE.}
}
\value{
An object of class \code{test_lin}. Contains linear regression results, and
data required to plot diagnostics.
}
\description{
Randomly generate a dataset and runs \code{auto_rate()} on the data to detect
linear regions (with \code{method = "linear"}). The function plots 4 exploratory
graphs and outputs the results of a linear regression between detected rate
and true (known) rate, which can demonstrate how much the function is able to
predict true rate.
}
\examples{
# run 3 iterations (please run at least 1000 times for more reliable visuals)
x <- test_lin(reps = 3)
# plot(x)
# plot(x, "a")  # view only plot "A"
# plot(x, "d")  # view only plot "D". You know what to do (for other plots).
}
\keyword{internal}
