% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxtracto_3D.R
\name{rxtracto_3D}
\alias{rxtracto_3D}
\title{Extract environmental data in a 3-dimensional box from an 'ERDDAP' server using 'rerddap'.}
\usage{
rxtracto_3D(
  dataInfo,
  parameter = NULL,
  xcoord = NULL,
  ycoord = NULL,
  zcoord = NULL,
  tcoord = NULL,
  xName = "longitude",
  yName = "latitude",
  zName = "altitude",
  tName = "time",
  verbose = FALSE,
  cache_remove = TRUE
)
}
\arguments{
\item{dataInfo}{- the return from an 'rerddap:info' call to an 'ERDDAP' server}

\item{parameter}{- character string containing the name of the parameter to extract}

\item{xcoord}{- a real array with the x-coordinates of the trajectory (if longitude in #'   decimal degrees East, either 0-360 or -180 to 180)}

\item{ycoord}{-  a real array with the y-coordinate of the trajectory (if latitude in
decimal degrees N; -90 to 90)}

\item{zcoord}{-  a real array with the z-coordinate (usually altitude or depth)}

\item{tcoord}{- a character array with the times of the trajectory in
"YYYY-MM-DD" - for now restricted to be time.}

\item{xName}{- character string with name of the xcoord in the 'ERDDAP' dataset (default "longitude")}

\item{yName}{- character string with name of the ycoord in the 'ERDDAP' dataset (default "latitude")}

\item{zName}{- character string with name of the zcoord in the 'ERDDAP' dataset (default "altitude")}

\item{tName}{- character string with name of the tcoord in the 'ERDDAP' dataset (default "time")}

\item{verbose}{- logical variable (default FALSE) if the the URL request should be verbose}

\item{cache_remove}{- logical variable (default TRUE) whether to delete 'rerddap' cache}
}
\value{
If successful a structure with data and dimensions:
\itemize{
  \item extract$data - the data array dimensioned (lon,lat,time)
  \item extract$varname - the name of the parameter extracted
  \item extract$datasetname - ERDDAP dataset name
  \item extract$longitude - the longitudes on some scale as request
  \item extract$latitude - the latitudes always going south to north
  \item extract$time - the times of the extracts
  }
  else an error string
}
\description{
\code{rxtracto_3D} uses the R program 'rerddap' to extract environmental data
from an 'ERDDAP' server in an (x,y,z, time) bounding box.
The same call could be made directly in rerddap,
but function is maintained as it is used in the polygon routine.
}
\examples{
## toy example to show use
## and keep execution time low
##
# dataInfo <- rerddap::info('erdHadISST')
parameter <- 'sst'
xcoord <- c(-130.5, -130.5)
ycoord <- c(40.5, 40.5)
tcoord <- c('2006-01-16', '2006-01-16')
# extract <- rxtracto_3D(dataInfo, parameter, xcoord = xcoord, ycoord = ycoord,
#                        tcoord = tcoord)

## bathymetry example
## 2-D example getting bathymetry
dataInfo <- rerddap::info('etopo360')
parameter <- 'altitude'
# extract <- rxtracto_3D(dataInfo, parameter, xcoord = xcoord, ycoord = ycoord)
}
