% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repsd_pval.R
\name{repsd_pval}
\alias{repsd_pval}
\title{Calculating p-values for repsd}
\usage{
repsd_pval(
  alpha = 0.05,
  null_dist = null_repsd(),
  items_repsd = repsd()$repsd_each_item,
  responses = timmsData,
  focalColumn = 21,
  verbose = TRUE
)
}
\arguments{
\item{alpha}{numeric. The alpha level to calculate significance.}

\item{null_dist}{A \code{data.frame}-type object with the null distribution simulation for each item as columns.}

\item{items_repsd}{A numeric vector of the repsd values for each item.}

\item{responses}{The \code{data.frame} of item responses and the focal column.}

\item{focalColumn}{The column number for the focal column. Removed from the final data.}

\item{verbose}{Logical. Do you want to print the results to console (\code{TRUE}, default)
or return the results invisibly (\code{FALSE})?}
}
\value{
If the \code{colorDF} package is installed and accessible, a \code{colorDF}
with the significant items highlighted. Otherwise, a \code{data.frame}. Both have
columns with the \code{items} names, the \code{repsd} value, the \code{p.value}, and the
\code{sig} (0 = false, 1 = true) for each item.
}
\description{
Calculating p-values for repsd
}
\details{
Calculates the p-values for \code{repsd} for the data set.
It can be used as a wrapper function by providing
the \code{\link[=null_repsd]{null_repsd()}} function and the \code{repsd_each_item}
output of the \code{\link[=repsd]{repsd()}} function (each with proper
arguments) as the arguments to \code{null_dist} and
\code{items_repsd}, respectively.
}
