% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entrez_citmatch.r
\name{entrez_citmatch}
\alias{entrez_citmatch}
\title{Fetch pubmed ids matching specially formatted citation strings}
\usage{
entrez_citmatch(bdata, db = "pubmed", retmode = "xml", config = NULL)
}
\arguments{
\item{bdata}{character, containing citation data. 
Each citation must be represented in a pipe-delimited format
 journal_title|year|volume|first_page|author_name|your_key|
The final field "your_key" is arbitrary, and can used as you see
fit. Fields can be left empty, but be sure to keep 6 pipes.}

\item{db}{character, the database to search. Defaults to pubmed,
the only database currently available}

\item{retmode}{character, file format to retrieve. Defaults to xml, as 
per the API documentation, though note the API only returns plain text}

\item{config}{vector configuration options passed to httr::GET}
}
\value{
A character vector containing PMIDs
}
\description{
Fetch pubmed ids matching specially formatted citation strings
}
\examples{
\donttest{
ex_cites <- c("proc natl acad sci u s a|1991|88|3248|mann bj|test1|",
              "science|1987|235|182|palmenberg ac|test2|")
entrez_citmatch(ex_cites)
}
}
\seealso{
\code{\link[httr]{config}} for available configs
}

