% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.remiod.R
\name{summary}
\alias{summary}
\alias{summary.remiod}
\alias{print.summary.remiod}
\alias{coef.summary.remiod}
\title{Summarize the results from an object of class remiod}
\usage{
summary(object, ...)

\method{summary}{remiod}(object, start = NULL, end = NULL, thin = NULL,
  quantiles = c(0.025, 0.975), outcome = NULL, exclude_chains = NULL,
  warn = TRUE, mess = TRUE, ...)

\method{print}{summary.remiod}(x, digits = 3, ...)

\method{coef}{summary.remiod}(object, start = NULL, end = NULL,
  thin = NULL, subset = NULL, exclude_chains = NULL, warn = TRUE,
  mess = TRUE, ...)
}
\arguments{
\item{object}{object inheriting from class 'remoid'}

\item{...}{additional, optional arguments
\describe{
\item{\code{trunc}}{named list specifying limits of truncation for the
distribution of the named incomplete variables (see the
vignette
\href{https://nerler.github.io/JointAI/articles/ModelSpecification.html#functions-with-restricted-support}{ModelSpecification})}
\item{\code{hyperpars}}{list of hyper-parameters, as obtained by
\code{\link[JointAI]{default_hyperpars}()}}
\item{\code{scale_vars}}{named vector of (continuous) variables that
will be centred and scaled (such that mean = 0 and sd = 1)
when they enter a linear predictor to improve
convergence of the MCMC sampling. Default is that all
numeric variables and integer variables with >20 different
values will be scaled.
If set to \code{FALSE} no scaling will be done.}
\item{\code{custom}}{named list of JAGS model chunks (character strings)
that replace the model for the given variable.}
\item{\code{append_data_list}}{list that will be appended to the list
containing the data that is passed to \strong{rjags}
(\code{data_list}). This may be necessary if additional data /
variables are needed for custom (covariate) models.}
\item{\code{progress.bar}}{character string specifying the type of
progress bar. Possible values are "text" (default), "gui",
and "none" (see \code{\link[rjags]{update}}). Note: when
sampling is performed in parallel it is not possible to
display a progress bar.}
\item{\code{quiet}}{logical; if \code{TRUE} then messages generated by
\strong{rjags} during compilation as well as the progress bar
for the adaptive phase will be suppressed,
(see \code{\link[rjags]{jags.model}})}
\item{\code{keep_scaled_mcmc}}{should the "original" MCMC sample (i.e.,
the scaled version returned by \code{coda.samples()}) be
kept? (The MCMC sample that is re-scaled to the scale of the
data is always kept.)}
\item{\code{modelname}}{character string specifying the name of the
model file (including the ending, either .R or .txt). If
unspecified a random name will be generated.}
\item{\code{modeldir}}{directory containing the model file or directory
in which the model file should be written. If unspecified a
temporary directory will be created.}
\item{\code{overwrite}}{logical; whether an existing model file with
the specified \code{<modeldir>/<modelname>} should be
overwritten. If set to \code{FALSE} and a model already
exists, that model will be used. If unspecified (\code{NULL})
and a file exists, the user is asked for input on how to
proceed.}
\item{\code{keep_model}}{logical; whether the created JAGS model file
should be saved or removed from (\code{FALSE}; default) when
the sampling has finished.}
}}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (integer; see \code{\link[coda]{window.mcmc}}).
For example, \code{thin = 1} (default) will keep the MCMC samples
from all iterations; \code{thin = 5} would only keep every 5th
iteration.}

\item{quantiles}{posterior quantiles}

\item{outcome}{specify outcome variable to select imputation model(s) to summarize.
Default generates summaries for all models.}

\item{exclude_chains}{optional vector of the index numbers of chains that
should be excluded}

\item{warn}{logical; should warnings be given? Default is
\code{TRUE}.}

\item{mess}{logical; should messages be given? Default is
\code{TRUE}.}

\item{x}{an object of class \code{summary.remiod}}

\item{digits}{the minimum number of significant digits to be printed in values.}

\item{subset}{subset of parameters/variables/nodes (columns in the MCMC
sample). Follows the same principle as the argument
\code{monitor_params} and \code{selected_parms}.}
}
\value{
summary information, including parameter posterior mean, posterior SD,
quantiles, tail probability \code{tail-prob},  Gelman-Rubin criterion
\code{GR-crit}, the ratio of the Monte Carlo error and posterior standard
deviation) for specified parameters \code{MCE/SD}.
}
\description{
Obtain and print the \code{summary}, (fixed effects) coefficients
(\code{coef}) and credible interval (\code{confint}).
}
\examples{
\donttest{
# data(schizow)

test = remiod(formula = y6 ~ tx + y0 + y1 + y3, data = schizow,
              trtvar = 'tx', algorithm = 'jags', method="MAR",
              ord_cov_dummy = FALSE, n.adapt = 50, n.chains = 1,
              n.iter = 50, thin = 2, warn = FALSE, seed = 1234)

summary(object = test, outcome = c("y6","y3"))
}

}
