% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.table.R
\name{to_long_tab}
\alias{to_long_tab}
\title{Convert the regression result to the long format: the standard errors are in parentheses and beneath the betas}
\usage{
to_long_tab(reg.coef, d = 3, t.value.col = 3, Pr.col = 4)
}
\arguments{
\item{reg.coef}{a data.frame (or matrix) of regression result or a coeftest object, e.g. summary(lm_model)$coef, coeftest(lm_model, cluster.vcov(lm_model, cbind(data$group1,  data$group2)))}

\item{d}{number of decimal places to retain}

\item{t.value.col}{col number of the t-score in the reg.coef data.frame}

\item{Pr.col}{col number of the Prob.(>|t|)) in the reg.coef data.frame}
}
\description{
Convert the regression result to the long format: the standard errors are in parentheses and beneath the betas
}
\examples{
data(mtcars)
m1 <- lm(mpg ~ vs + carb + hp + wt + wt * hp , data = mtcars)
to_long_tab(reg.coef = summary(m1)$coef) 

}
