% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/06_calc_myreg_helpers_coef.R
\name{beta_hat}
\alias{beta_hat}
\title{Create a vector of coefficients from the mediator model (mreg)}
\usage{
beta_hat(mreg, mreg_fit, avar, cvar)
}
\arguments{
\item{mreg}{A character vector of length 1. Mediator regression type: \code{"linear"} or \code{"logistic"}.}

\item{mreg_fit}{Model fit object for mreg (mediator model).}

\item{avar}{A character vector of length 1. Treatment variable name.}

\item{cvar}{A character vector of length > 0. Covariate names. Use \code{NULL} if there is no covariate. However, this is a highly suspicious situation. Even if \code{avar} is randomized, \code{mvar} is not. Thus, there should usually be some confounder(s) to account for the common cause structure (confounding) between \code{avar} and \code{yvar}.}
}
\value{
A named numeric vector of coefficients.
}
\description{
This function extracts \code{\link{coef}} from \code{mreg_fit} and pads with zeros appropriately to create a named vector consistently having the following elements:
\code{(Intercept)}
\code{avar}
\code{cvar}: This part is eliminated when \code{cvar = NULL}.
}
