context("conversions")

## Mostly regression tests for the conversions.  This will grow as I
## identify bugs and should act to stop them reappearing.
test_that("difficult conversions", {
  redis_flatten_command <- function(list) {
    .Call(Credis_flatten_command, list, PACKAGE = "redux")
  }
  redis_check_command <- function(list) {
    .Call(Credis_check_command, list, PACKAGE = "redux")
  }

  ## Was throwing an error because of the 0L in there.
  x <- list("SCAN", 0L, list("MATCH", "Mk0FylY:*"), NULL)
  expect_equal(redis_flatten_command(x), unlist(x, FALSE))

  ## As generated by
  x <- list("foo", 1:2)
  expect_equal(redis_flatten_command(x), list("foo", 1:2))
  expect_equal(redis_check_command(x), list("foo", c("1", "2")))
})

test_that("raw detection", {
  con <- test_hiredis_connection()
  on.exit(con$DEL("key"))

  d <- as.raw(c(1L, 5L, 127L, 0L, 99L))
  con$SET("key", d)
  expect_equal(con$GET("key"), d)

  con$SET("key", d[1:4])
  expect_equal(con$GET("key"), d[1:4])

  con$SET("key", d[1:3])
  expect_equal(con$GET("key"), rawToChar(d[1:3]))

  ## The serialisation header might not be enough:
  d <- c(serialize(NULL, NULL)[1:2], as.raw(1:5))
  con$SET("key", d)
  expect_is(con$GET("key"), "character")
  d <- c(serialize(NULL, NULL, xdr = FALSE)[1:2], as.raw(1:5))
  con$SET("key", d)
  expect_is(con$GET("key"), "character")
})

## Redis stores integers as strings, so make sure that TRUE/FALSE
## store as 1 / 0
test_that("logical", {
  con <- test_hiredis_connection()
  on.exit(con$DEL("key"))

  con$SET("key", TRUE)
  expect_equal(con$GET("key"), "1")
  con$SET("key", FALSE)
  expect_equal(con$GET("key"), "0")

  con$SET("key", "TRUE")
  expect_equal(con$GET("key"), "TRUE")
  con$SET("key", "FALSE")
  expect_equal(con$GET("key"), "FALSE")
})

test_that("invalid argument types", {
  con <- test_hiredis_connection()
  on.exit(con$DEL("key"))
  ## TODO: this error message is _useless_ as it refers to the
  ## low-level list used internally to hold arguments and not the
  ## arguments as passed in by the user.
  expect_error(con$SET("key", 1+3i),
               "Incompatible list element")
})

test_that("long integers", {
  con <- test_hiredis_connection()
  key <- rand_str()
  on.exit(con$DEL(key))

  con$SET(key, "Hello")

  t <- as.integer(con$TIME()[[1]])
  expect_equal(con$EXPIREAT(key, t + 1000000000), 1)

  t0 <- con$TTL(key)
  t1 <- con$PTTL(key)
  expect_equal(storage.mode(t0), "integer")
  expect_equal(storage.mode(t1), "double")
})
