% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{recipes_argument_select}
\alias{recipes_argument_select}
\title{Evaluate a selection with tidyselect semantics for arguments}
\usage{
recipes_argument_select(
  quos,
  data,
  info,
  single = TRUE,
  arg_name = "outcome",
  call = caller_env()
)
}
\arguments{
\item{quos}{A list of quosures describing the selection. Captured with
\code{\link[rlang:enquo]{rlang::enquos()}} and stored in the step object corresponding to the
argument.}

\item{data}{A data frame to use as the context to evaluate the selection in.
This is generally the \code{training} data passed to the \code{\link[=prep]{prep()}} method of your
step.}

\item{info}{A data frame of term information describing each column's type
and role for use with the recipes selectors. This is generally the \code{info}
data passed to the \code{\link[=prep]{prep()}} method of your step.}

\item{single}{A logical. Should an error be thrown if more than 1 variable is
selected. Defaults to \code{TRUE}.}

\item{arg_name}{A string. Name of argument, used to enrich error messages.}

\item{call}{The execution environment of a currently running function, e.g.
\code{caller_env()}. The function will be mentioned in error messages as the
source of the error. See the call argument of \code{\link[rlang:abort]{rlang::abort()}} for more
information.}
}
\value{
A character vector containing the evaluated selection.
}
\description{
\code{recipes_argument_select()} is a variant of
\code{\link[=recipes_eval_select]{recipes_eval_select()}} that is tailored to work well with arguments in steps
that specify variables. Such as \code{denom} in \code{\link[=step_ratio]{step_ratio()}}.

This is a developer tool that is only useful for creating new recipes steps.
}
\details{
This function is written to be backwards compatible with previous input types
of these arguments. Will thus accept strings, tidyselect, recipes selections,
helper functions \code{\link[=imp_vars]{imp_vars()}} in addition to the prefered bare names.
}
\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(rlang)
data(scat, package = "modeldata")

rec <- recipe(Species ~ ., data = scat)

info <- summary(rec)
info

recipes_argument_select(quos(Year), scat, info)
recipes_argument_select(vars(Year), scat, info)
recipes_argument_select(imp_vars(Year), scat, info)
\dontshow{\}) # examplesIf}
}
\seealso{
\link{developer_functions}
}
