% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R
\name{step_filter}
\alias{step_filter}
\alias{tidy.step_filter}
\title{Filter rows using dplyr}
\usage{
step_filter(recipe, ..., role = NA, trained = FALSE, inputs = NULL,
  skip = FALSE, id = rand_id("filter"))

\method{tidy}{step_filter}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{Logical predicates defined in terms of the variables
in the data. Multiple conditions are combined with \code{&}. Only
rows where the condition evaluates to \code{TRUE} are kept. See
\code{\link[dplyr:filter]{dplyr::filter()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{inputs}{Quosure of values given by \code{...}.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_filter} object}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which
contains the conditional statements. These
expressions are text representations and are not parsable.
}
\description{
\code{step_filter} creates a \emph{specification} of a recipe step
that will remove rows using \code{\link[dplyr:filter]{dplyr::filter()}}.
}
\details{
When an object in the user's global environment is
referenced in the expression defining the new variable(s),
it is a good idea to use quasiquotation (e.g. \code{!!}) to embed
the value of the object in the expression (to be portable
between sessions). See the examples.
}
\examples{
rec <- recipe( ~ ., data = iris) \%>\%
  step_filter(Sepal.Length > 4.5, Species == "setosa")

prepped <- prep(rec, training = iris \%>\% slice(1:75), retain = TRUE)

library(dplyr)

dplyr_train <-
  iris \%>\%
  as_tibble() \%>\%
  slice(1:75) \%>\%
  dplyr::filter(Sepal.Length > 4.5, Species == "setosa")

rec_train <- juice(prepped)
all.equal(dplyr_train, rec_train)

dplyr_test <-
  iris \%>\%
  as_tibble() \%>\%
  slice(76:150) \%>\%
  dplyr::filter(Sepal.Length > 4.5, Species != "setosa")
rec_test <- bake(prepped, iris \%>\% slice(76:150))
all.equal(dplyr_test, rec_test)

values <- c("versicolor", "virginica")

qq_rec <-
  recipe( ~ ., data = iris) \%>\%
  # Embed the `values` object in the call using !!
  step_filter(Sepal.Length > 4.5, Species  \%in\% !!values)

tidy(qq_rec, number = 1)
}
\concept{preprocessing}
\concept{row_filters}
\keyword{datagen}
