% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zv.R
\name{step_zv}
\alias{step_zv}
\alias{tidy.step_zv}
\title{Zero Variance Filter}
\usage{
step_zv(recipe, ..., role = NA, trained = FALSE, removals = NULL,
  skip = FALSE, id = rand_id("zv"))

\method{tidy}{step_zv}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which
variables that will evaluated by the filtering. See
\code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{removals}{A character string that contains the names of
columns that should be removed. These values are not determined
until \code{\link[=prep.recipe]{prep.recipe()}} is called.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_zv} object.}
}
\value{
An updated version of \code{recipe} with the new step
added to the sequence of existing steps (if any). For the
\code{tidy} method, a tibble with columns \code{terms} which
is the columns that will be removed.
}
\description{
\code{step_zv} creates a \emph{specification} of a recipe step
that will remove variables that contain only a single value.
}
\examples{
data(biomass)

biomass$one_value <- 1

biomass_tr <- biomass[biomass$dataset == "Training",]
biomass_te <- biomass[biomass$dataset == "Testing",]

rec <- recipe(HHV ~ carbon + hydrogen + oxygen +
                    nitrogen + sulfur + one_value,
              data = biomass_tr)

zv_filter <- rec \%>\%
  step_zv(all_predictors())

filter_obj <- prep(zv_filter, training = biomass_tr)

filtered_te <- bake(filter_obj, biomass_te)
any(names(filtered_te) == "one_value")

tidy(zv_filter, number = 1)
tidy(filter_obj, number = 1)
}
\seealso{
\code{\link[=step_nzv]{step_nzv()}} \code{\link[=step_corr]{step_corr()}}
\code{\link[=recipe]{recipe()}}
\code{\link[=prep.recipe]{prep.recipe()}} \code{\link[=bake.recipe]{bake.recipe()}}
}
\concept{preprocessing variable_filters}
\keyword{datagen}
