% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/class-groups.R
\name{ClassGroups}
\alias{ClassGroups}
\alias{alnum}
\alias{alpha}
\alias{any_char}
\alias{ascii_alnum}
\alias{ascii_alpha}
\alias{ascii_digit}
\alias{ascii_lower}
\alias{ascii_upper}
\alias{blank}
\alias{char_range}
\alias{cntrl}
\alias{dgt}
\alias{digit}
\alias{graph}
\alias{hex_digit}
\alias{iso_date}
\alias{iso_datetime}
\alias{iso_time}
\alias{lower}
\alias{not_dgt}
\alias{not_spc}
\alias{not_wrd}
\alias{printable}
\alias{punct}
\alias{roman}
\alias{space}
\alias{spc}
\alias{upper}
\alias{wrd}
\title{Class Groups}
\usage{
alnum(lo, hi, char_class = TRUE)

alpha(lo, hi, char_class = TRUE)

blank(lo, hi, char_class = TRUE)

cntrl(lo, hi, char_class = TRUE)

digit(lo, hi, char_class = TRUE)

graph(lo, hi, char_class = TRUE)

lower(lo, hi, char_class = TRUE)

printable(lo, hi, char_class = TRUE)

punct(lo, hi, char_class = TRUE)

space(lo, hi, char_class = TRUE)

upper(lo, hi, char_class = TRUE)

hex_digit(lo, hi, char_class = TRUE)

any_char(lo, hi)

dgt(lo, hi, char_class = TRUE)

wrd(lo, hi, char_class = TRUE)

spc(lo, hi, char_class = TRUE)

not_dgt(lo, hi, char_class = TRUE)

not_wrd(lo, hi, char_class = TRUE)

not_spc(lo, hi, char_class = TRUE)

ascii_digit(lo, hi, char_class = TRUE)

ascii_lower(lo, hi, char_class = TRUE)

ascii_upper(lo, hi, char_class = TRUE)

ascii_alpha(lo, hi, char_class = TRUE)

ascii_alnum(lo, hi, char_class = TRUE)

iso_date(lo, hi, char_class = TRUE)

iso_time(lo, hi, char_class = TRUE)

iso_datetime(lo, hi, char_class = TRUE)

roman(lo, hi, char_class = TRUE)

char_range(lo, hi, char_class = lo != hi)
}
\arguments{
\item{lo}{A non-negative integer. Minimum number of repeats, when grouped.}

\item{hi}{positive integer. Maximum number of repeats, when grouped.}

\item{char_class}{\code{TRUE} or \code{FALSE}. Should the values be wrapped
into a character class?}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match groups of classes
}
\note{
R has many built-in locale-dependent character classes, like
\code{[:alnum:]} (representing lower or upper case letters or numbers).
There are also some generic character classes like \code{\\w} (representing
lower or upper case letters or numbers or underscores).
Finally, there are ASCII-only ways of specifying letters like \code{a-zA-Z}.
Which version you want depends upon how you want to deal with international
characters, and the vagaries of the underlying regular expression engine.
I suggest reading the \code{\link[base]{regex}} help page and doing lots of
testing.
}
\examples{
# R character classes
alnum()
alpha()
blank()
cntrl()
digit()
graph()
lower()
printable()
punct()
space()
upper()
hex_digit()

# Generic classes
any_char()
dgt()
wrd()
spc()

# Generic negated classes
not_dgt()
not_wrd()
not_spc()

# Non-locale-specific classes
ascii_digit()
ascii_lower()
ascii_upper()

# ISO 8601 date-time classes
iso_date()
iso_time()
iso_datetime()

# Roman numerals
roman()

#Grouping and repetition
digit(char_class = FALSE)
digit(3)
digit(3, 5)
digit(0)
digit(1)
digit(0, 1)
}
\references{
\url{http://www.regular-expressions.info/shorthand.html}
}
\seealso{
\code{\link[base]{regex}}, \code{\link{Unicode}}
}

