% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rearrr_fn_docs.R
\name{rearrr_fn_}
\alias{rearrr_fn_}
\title{Parent function for documentation inheritance}
\usage{
rearrr_fn_(data, origin_fn, check_fn, allowed_types, force_df, min_dims)
}
\arguments{
\item{data}{\code{data.frame} or \code{vector}.}

\item{origin_fn}{Function for finding the origin coordinates.

\strong{Input}: Each column will be passed as a \code{vector} in the order of \code{`cols`}.

\strong{Output}: A \code{vector} with one scalar per dimension.

Can be created with \code{\link[rearrr:create_origin_fn]{create_origin_fn()}} if you want to apply
the same function to each dimension.

E.g. \code{`create_origin_fn(median)`} would find the median of each column.

\strong{Built-in functions} are \code{\link[rearrr:centroid]{centroid()}},
\code{\link[rearrr:most_centered]{most_centered()}},
and \code{\link[rearrr:midrange]{midrange()}}}

\item{check_fn}{Function with checks post-preparation of \code{`data`} and \code{`col(s)`}.
Should not return anything.}

\item{allowed_types}{Allowed types of the \code{`col(s)`} columns. The type restrictions do not apply to
columns not mentioned in the \code{`col(s)`} argument.}

\item{force_df}{Whether to return a \code{data.frame} when \code{`data`} is a \code{vector}.}

\item{min_dims}{Minimum number of dimensions (cols) after preparations. When \code{`data`} is a \code{vector}
setting \code{`min_dims`} to \code{2} will use both the index and the values as columns.}

\item{overwrite}{Whether to allow overwriting of existing columns. (Logical)}
}
\description{
Do not call. Only used to avoid repetition of documentation.
}
\keyword{internal}
