% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DDM.R
\name{DDM}
\alias{DDM}
\alias{dDDM}
\alias{pDDM}
\alias{rDDM}
\title{7 Parameter Drift Diffusion Model}
\usage{
dDDM(rt, resp, phi, x_res = "default", t_res = "default")

pDDM(rt, resp, phi, x_res = "default", t_res = "default")

rDDM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item non-decision time distribution. Must be an integer of either 0 = delta distribution
(i.e., single point), 1 = uniform distribution, 2 = truncated normal distribution, or
3 = inverse Gauss distribution.
\item Mean non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Width of non-decision time (\eqn{s_{t_{nd}}}). If the non-decision time distribution is
delta (0) then this value is ignored, if it is 1 (uniform) then this value is half of the
range, if it is truncated normal (2) then this value is is the standard deviation, and
if it is inverse Gauss (3) then this value is the shape (\eqn{\lambda}).
\item relative start distribution. Must be an integer of either 0 = delta distribution
(i.e., single point), 1 = uniform distribution, or 2 = truncated normal distribution.
\item Mean relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Width of the relative start (\eqn{s_w}). If the relative start distribution is delta (0) then
this value is ignored, if it is uniform (1) then this value is half of the range and if
it is truncated normal (2) then this value is the standard deviation.
\item Stimulus strength distribution. Must be an integer of either 0 = uniform distribution
or 1 = normal distribution.
\item Mean stimulus strength (\eqn{\mu}). Strength of the stimulus and used to set the drift
rate. For the DDM, \eqn{v(x,t) = \mu}.
\item Width of stimulus strength (\eqn{s_{\mu}}). If the distribution is uniform (0) then this
value is half of the range and if it is normal (1) then this value is the standard deviation.
\item Noise scale (\eqn{\sigma}). Model scaling parameter.
\item Decision thresholds (\eqn{b}). Sets the location of each decision threshold. The
upper threshold \eqn{b_u} is above 0 and the lower threshold \eqn{b_l} is below 0 such that
\eqn{b_u = -b_l = b}. The threshold separation \eqn{a = 2b}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
Density (PDF), distribution function (CDF), and random sampler for the 7 parameter drift
diffusion model (DDM).
}
\examples{
# Probability density function
dDDM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(1, 0.3, 0.05, 1, 0.586, 0.174, 1, 1.0, 2.0, 1.0, 0.75, 0.0, 0.0, 1.0))

# Cumulative distribution function
pDDM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(1, 0.3, 0.05, 1, 0.586, 0.174, 1, 1.0, 2.0, 1.0, 0.75, 0.0, 0.0, 1.0))

# Random sampling
rDDM(n = 100, phi = c(1, 0.3, 0.05, 1, 0.586, 0.174, 1, 1.0, 2.0, 1.0, 0.75, 0.0, 0.0, 1.0))
}
\references{
Ratcliff, R. (1978). A theory of memory retrieval. \emph{Psychological Review, 85}(2), 59-108.

Ratcliff, R., & McKoon, G. (2008). The Diffusion Decision Model: Theory and Data
for Two-Choice Decision Tasks. \emph{Neural Computation, 20}(4), 873-922.
}
\author{
Raphael Hartmann & Matthew Murrow
}
