% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LIM.R
\name{LIM}
\alias{LIM}
\alias{dLIM}
\alias{pLIM}
\alias{rLIM}
\title{Leaky Integration Model}
\usage{
dLIM(rt, resp, phi, x_res = "default", t_res = "default")

pLIM(rt, resp, phi, x_res = "default", t_res = "default")

rLIM(n, phi, dt = 1e-05)
}
\arguments{
\item{rt}{vector of response times}

\item{resp}{vector of responses ("upper" and "lower")}

\item{phi}{parameter vector in the following order:
\enumerate{
\item Non-decision time (\eqn{t_{nd}}). Time for non-decision processes such as stimulus
encoding and response execution. Total decision time t is the sum of the decision
and non-decision times.
\item Relative start (\eqn{w}). Sets the start point of accumulation as a ratio of
the two decision thresholds. Related to the absolute start z point via equation
\eqn{z = b_l + w*(b_u - b_l)}.
\item Stimulus strength (\eqn{\mu}). Strength of the stimulus.
\item Log10-leakage (\eqn{log_{10}(L)}). Rate of leaky integration.
\item Noise scale (\eqn{\sigma}). Model scaling parameter.
\item Decision thresholds (\eqn{b}). Sets the location of each decision threshold. The
upper threshold \eqn{b_u} is above 0 and the lower threshold \eqn{b_l} is below 0 such that
\eqn{b_u = -b_l = b}. The threshold separation \eqn{a = 2b}.
\item Contamination (\eqn{g}). Sets the strength of the contamination process. Contamination
process is a uniform distribution \eqn{f_c(t)} where \eqn{f_c(t) = 1/(g_u-g_l)}
if \eqn{g_l <= t <= g_u} and \eqn{f_c(t) = 0} if \eqn{t < g_l} or \eqn{t > g_u}. It is
combined with PDF \eqn{f_i(t)} to give the final combined distribution
\eqn{f_{i,c}(t) = g*f_c(t) + (1-g)*f_i(t)}, which is then output by the program.
If \eqn{g = 0}, it just outputs \eqn{f_i(t)}.
\item Lower bound of contamination distribution (\eqn{g_l}). See parameter \eqn{g}.
\item Upper bound of contamination distribution (\eqn{g_u}). See parameter \eqn{g}.
}}

\item{x_res}{spatial/evidence resolution}

\item{t_res}{time resolution}

\item{n}{number of samples}

\item{dt}{step size of time. We recommend 0.00001 (1e-5)}
}
\value{
For the density a list of PDF values, log-PDF values, and the sum of the
log-PDFs, for the distribution function a list of of CDF values, log-CDF values,
and the sum of the log-CDFs, and for the random sampler a list of response
times (rt) and response thresholds (resp).
}
\description{
SDDM modified to encode leaky integration in the drift rate. Also known as an
Ornstein-Uhlenbeck model, its drift rate is \eqn{v(x,t) = \mu - L*x} where \eqn{L} is the
leakage rate. All other parameters are unchanged from the SDDM. Leakage describes
the rate at which old information is lost from the accumulator, occurring on a
time scale of approximately \eqn{1/L}. The LIM is used to model decay of excitatory
currents in decision neurons (Usher & McClelland, 2001; Wong & Wang, 2006) and
has been proposed as a mechanism for preference reversals under time pressure
(Busemeyer & Townsend, 1993). Due to its neural plausibility and simple functional
form, recent work has proposed it as an alternative psychometric tool to the SDDM
(Wang & Donkin, 2024).
}
\examples{
# Probability density function
dLIM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 0.5, 1.0, 0.5, 0.0, 0.0, 1.0))

# Cumulative distribution function
pLIM(rt = c(1.2, 0.6, 0.4), resp = c("upper", "lower", "lower"),
     phi = c(0.3, 0.5, 1.0, 0.5, 1.0, 0.5, 0.0, 0.0, 1.0))

# Random sampling
rLIM(n = 100, phi = c(0.3, 0.5, 1.0, 0.5, 1.0, 0.5, 0.0, 0.0, 1.0))
}
\references{
Busemeyer, J. R., & Townsend, J. T. (1993). Decision field theory: A dynamic-cognitive
approach to decision making in an uncertain environment. \emph{Psychological Review, 100}(3), 432-459.

Usher, M., & McClelland, J. L. (2001). The time course of perceptual choice: The leaky,
competing accumulator model. \emph{Psychological Review, 108}(3), 550-592.

Wang, J.-S., & Donkin, C. (2024). The neural implausibility of the diffusion decision
model doesn’t matter for cognitive psychometrics, but the Ornstein-Uhlenbeck model
is better. \emph{Psychonomic Bulletin & Review}.

Wong, K.-F., & Wang, X.-J. (2006). A Recurrent Network Mechanism of Time Integration
in Perceptual Decisions. \emph{The Journal of Neuroscience, 26}(4), 1314-1328.
}
\author{
Raphael Hartmann & Matthew Murrow
}
