% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{simDat}
\alias{simDat}
\title{Simulated dataset for demonstration}
\format{
A data frame with 874 rows and 7 variables.
}
\usage{
data(simDat)
}
\description{
A simulated data frame with the following variables
\describe{
  \item{id}{subjects identification}
  \item{t.start}{start of the interval}
  \item{t.stop}{endpoint of the interval; when time origin is 0 this variable also marks the recurrence or terminal/censoring time}
  \item{status}{terminal event indicator; 1 if a terminal event is recorded}
  \item{event}{recurrent event indicator; 1 if a recurrent event is recorded}
  \item{x1}{baseline covariate generated from a standard uniform distribution}
  \item{x2}{baseline covariate generated from a standard uniform distribution (independent from \code{z1}}
}
}
\details{
The sample dataset \code{simDat} is generated by
\code{set.seed(0); dat <- simGSC(200)}.
See \code{\link{simGSC}} for instruction on simulating recurrent event data from
scale-change models.
}
