% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdoc.R
\name{rdoc}
\alias{rdoc}
\alias{rdoc_usage}
\alias{rdoc_arguments}
\alias{rdoc_details}
\alias{rdoc_examples}
\title{Colourised \R documentation}
\usage{
rdoc(topic, package = NULL, lib.loc = NULL)

rdoc_usage(topic, package = NULL, lib.loc = NULL)

rdoc_arguments(topic, package = NULL, lib.loc = NULL)

rdoc_details(topic, package = NULL, lib.loc = NULL)

rdoc_examples(topic, package = NULL, lib.loc = NULL)
}
\arguments{
\item{topic}{\code{character(1)}, help topic}

\item{package}{\code{character(1)}, package of help topic. Defaults to
\code{NULL}}

\item{lib.loc}{\code{character(1)}, library location of package. Defaults to
\code{NULL}}
}
\description{
Refer to colourised \R docs as terminal output. Provides a replacement for
\code{help}. A number of common (substantive) section accessors are also
provided.
}
\details{
The manner in which content is outputted depends on where it is
  being used. If used from a terminal the contents will be outputted via
  \code{file.show}. Otherwise the output will be printed interactively by
  sections unless this has been disabled via \code{options(rdoc.by_section =
  FALSE)}. When printing by section pressing the <enter> keypress will show
  the next section. Any other keypress will exit the interaction without
  printing any remaining sections. Color support is checked via
  \code{crayon::has_color()}. Customising rdoc output is possible via
  `options`, see \code{\link{rdoc_options}} for more details.
}
\examples{
\donttest{

library(rdoc)
rdoc("rdoc")
rdoc_examples("min")
rdoc_usage(substr)

}
}
\concept{rdoc access}
