% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdb_providers.R
\name{rdb_providers}
\alias{rdb_providers}
\title{Download list of DBnomics providers.}
\usage{
rdb_providers(code = FALSE,
  use_readLines = getOption("rdbnomics.use_readLines"))
}
\arguments{
\item{code}{Logical (default \code{FALSE}). If \code{TRUE}, then only the
providers are returned in a vector.}

\item{use_readLines}{Logical (default \code{FALSE}). If \code{TRUE}, then
the data are requested and read with the base function \code{readLines}.
This can be used to get round the error \code{Could not resolve host: api.db.nomics.world}.}
}
\value{
A \code{data.frame}, a \code{data.table} or a vector.
}
\description{
\code{rdb_providers} downloads the list of providers from
\href{https://db.nomics.world/}{DBnomics}.
}
\details{
By default, the function returns a \code{data.frame} (or a \code{data.table})
containing the list of providers from
\href{https://db.nomics.world/}{DBnomics} with additional informations such as
the region, the website, etc.
}
\examples{
\dontrun{
rdb_providers()

rdb_providers(code = TRUE)
}
}
\seealso{
\code{\link{rdb_last_updates}}
}
