% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.solved.R
\name{is.solved}
\alias{is.solved}
\title{Testing if cube is solved}
\usage{
is.solved(cube)
}
\arguments{
\item{cube}{- cube object to be tested}
}
\value{
TRUE/FALSE
}
\description{
Function returns TRUE if cube is solved (each side contains exactly one colour) and FALSE otherwise.
}
\examples{
## Create new cube:
cube <- createCube(3)
## And it is solved:
is.solved(cube) # TRUE
## Now, test how many times repeating LFRB moves will bring back initial state:
cube <- twistCube(cube,'LFRB')
i <- 1
while(!is.solved(cube))
{
cube <- twistCube(cube,'LFRB')
i <- i + 1
}
print(i) # 315
## Check one more time if this is a solution:
is.solved(twistCube(cube,'LFRB',315)) # TRUE
## Check if really 314 moves and 316 moves don't give solution:
is.solved(twistCube(cube,'LFRB',314)) || is.solved(twistCube(cube,'LFRB',316)) # FALSE
}
