% Generated by roxygen2 (4.0.2): do not edit by hand
\name{cr_licenses}
\alias{cr_licenses}
\title{Search CrossRef licenses}
\usage{
cr_licenses(query = NULL, filter = NULL, offset = NULL, limit = NULL,
  sample = NULL, sort = NULL, order = NULL, .progress = "none", ...)
}
\arguments{
\item{query}{Query terms}

\item{filter}{Filter options. See details.}

\item{offset}{Number of record to start at, from 1 to infinity.}

\item{limit}{Number of results to return in the query. Not relavant when searching with specific
dois. Default: 20. Max: 1000}

\item{sample}{(integer) Number of random results to return. when you use the sample parameter,
the rows and offset parameters are ignored.}

\item{sort}{(character) Field to sort on, one of score, relevance, updated, deposited, indexed,
or published.}

\item{order}{(character) Sort order, one of 'asc' or 'desc'}

\item{.progress}{Show a \code{plyr}-style progress bar? Options are "none", "text", "tk", "win,
and "time".  See \code{\link[plyr]{create_progress_bar}} for details of each.}

\item{...}{Named parameters passed on to \code{\link[httr]{GET}}}
}
\description{
Search CrossRef licenses
}
\details{
BEWARE: The API will only work for CrossRef DOIs.
}
\examples{
\donttest{
cr_licenses()
cr_licenses(query = 'elsevier')
cr_licenses(filter = c(member=78))
cr_licenses(filter = c(issn='2090-8091'))
}
}
\references{
\url{https://github.com/CrossRef/rest-api-doc/blob/master/rest_api.md}
}

