% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_advanced_search.R
\name{core_advanced_search}
\alias{core_advanced_search}
\alias{core_advanced_search_}
\title{Advanced Search CORE}
\usage{
core_advanced_search(query, page = 1, limit = 10, key = NULL,
  parse = TRUE, ...)

core_advanced_search_(query, page = 1, limit = 10, key = NULL, ...)
}
\arguments{
\item{query}{data.frame, required (details for structure)}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\value{
data.frame with the following columns:
\code{status}: string, which will be 'OK' or 'Not found' or
'Too many queries' or 'Missing parameter' or 'Invalid parameter' or
'Parameter out of bounds'
\code{totalHits}: integer, Total number of items matching the search criteria
\code{data}: list, a list of relevant resources
}
\description{
Advanced Search CORE
}
\details{
\code{query} should include columns with the following information
(at least one is required):
\enumerate{
\item \code{all_of_the_words}: string, with space separated terms that should all
exist in target document(s)
\item \code{exact_phrase}: string, used as an absolute match in comparison with
\code{all_of_the_words}
\item \code{at_least_one_of_the_words}: string, with space separated terms of which
at least one should exist in target document(s)
\item \code{without_the_words}: string, with space separated terms of which none
should exist in target document(s)
\item \code{find_those_words}: 3 available options, a. "anywhere in the article"
(default),
b. "in the title", c. "in the title and abstract" to either do a fulltext
search, a title only or a title and abstract respectively
\item \code{author}: string, to be used as an absolute match against the author name
metadata field
\item \code{publisher}: string, to be used as an absolute match against the publisher
name metadata field
\item \code{repository}: string, to be used as an absolute match against the
repository name metadata field
\item \code{doi}: string, to be used as an absolute match against the repository
name metadata field (all other fields will be ignored if included)
\item \code{year_from}: string, to filter target document(s) publisher earlier than
indicated
\item \code{year_to}: string, to filter target document(s) publisher later than
indicated
\item \code{language}: string, to filter against languages specified in
https://en.wikipedia.org/wiki/ISO_639-1
\code{core_advanced_search} does the HTTP request and parses, while
\code{core_advanced_search_} just does the HTTP request, gives back JSON as a
character string
}
}
\examples{
\dontrun{
query <- data.frame(
"all_of_the_words" = c("data mining", "machine learning"),
"without_the_words" = c("social science", "medicine"),
"year_from" = c("2013","2000"),
"year_to" = c("2014", "2016"))

res <- core_advanced_search(query)
head(res$data)
res$data[[1]]$id
}
}
