% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoplot.troll.R
\name{autoplot,trollsim-method}
\alias{autoplot,trollsim-method}
\title{Plot TROLL simulation or stack}
\usage{
\S4method{autoplot}{trollsim}(
  object,
  what = "temporal",
  variables = NULL,
  species = NULL,
  iter = NULL
)
}
\arguments{
\item{object}{TROLL simulation or stack (see \code{\link[=troll]{troll()}}, \code{\link[=stack]{stack()}},
\code{\link[=trollsim]{trollsim()}} and \code{\link[=trollstack]{trollstack()}}).}

\item{what}{char. What to plot: "temporal", "spatial" "distribution", or
"lidar". "temporal" is for temporal trajectories of the whole ecosystem or
defined species. "spatial" is for spatial patterns in the initial or final
forest. "distribution" is for metrics distribution in the initial or final
forest. "lidar" is for canopy height model plot.}

\item{variables}{char. Which variable(s) to plot. Only one variable is
accepted when plotting "spatial".}

\item{species}{char. Which species to plot. NULL indicates the whole
ecosystem level. "all" can be used to use all species.}

\item{iter}{char. Which iteration(s) to plot, for temporal thinning or to
specify which forest to plot. "initial" or "final" can be used. NULL is
converted to "final".}
}
\value{
A \code{ggplot2} object.
}
\description{
\code{autoplot()} is a method that takes advantage of \code{ggplot2} to plot TROLL
simulations. \code{autoplot()} can plot either temporal trajectories of whole
ecosystem or species metrics (\code{what = 'temporal'}), the initial or final
pattern observed in the forest community (\code{what = 'spatial'} or \code{what = 'distribution'}), or lidar outputs (\code{what = 'lidar'}). Metrics includes
abundances of individuals above 1cm (N), above 10cm (N10), and above 30cm
(N30), aboveground biomass (AGB), basal area of individuals above 1cm (BA),
and above 10cm (BA10), gross primary production (GPP), net primary production
(NPP), respiration of day (Rday), night (Rnight) and stem (Rstem), and
litterfall.
}
\examples{

data("TROLLv3_output")
autoplot(TROLLv3_output)

}
\seealso{
\code{\link[=autogif]{autogif()}}, \link{summary,trollsim-method}
}
