% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_description.R
\name{add_description}
\alias{add_description}
\title{Create a DESCRIPTION file}
\usage{
add_description(
  given = NULL,
  family = NULL,
  email = NULL,
  orcid = NULL,
  organisation = NULL,
  open = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{given}{a character of length 1

The given name of the package maintainer.}

\item{family}{a character of length 1

The family name of the package maintainer.}

\item{email}{a character of length 1

The email address of the package maintainer.}

\item{orcid}{a character of length 1

The ORCID of the package maintainer.}

\item{organisation}{a character of length 1

The name of the GitHub organisation to host the package. If \code{NULL}
(default) the GitHub account will be used.}

\item{open}{a logical value

If \code{TRUE} (default) the file is opened in the editor.}

\item{overwrite}{a logical value

If a \code{DESCRIPTION} is already present and \code{overwrite = TRUE}, this file
will be erased and replaced. Default is \code{FALSE}.}

\item{quiet}{a logical value

If \code{TRUE} messages are deleted. Default is \code{FALSE}.}
}
\value{
None
}
\description{
This function creates a \code{DESCRIPTION} file at the root of the project based
on a template (adapted from \href{https://usethis.r-lib.org}{\code{usethis}}). User
credentials can be passed as arguments but it is recommended to store them
in the \code{.Rprofile} file with \code{\link[=set_credentials]{set_credentials()}}.
}
\examples{
\dontrun{
add_description(organisation = "MySociety")
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_compendium}()},
\code{\link{add_license}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
