% Generated by roxygen2 (4.0.2): do not edit by hand
\name{clinicaltrials_search}
\alias{clinicaltrials_search}
\title{Search for clinical trials satisfying a query}
\usage{
clinicaltrials_search(query = NULL, count = 20)
}
\arguments{
\item{query}{Search pattern as a string; a vector of key-value pairs is
interpreted as an advanced search and is therefore combined with '&'}

\item{count}{Limit the results to a specified integer. Set to NULL to include all results.}
}
\value{
A \code{data.frame} with the following columns: NCT study identifier, url, study title, status, condition summary, and date last changed
}
\description{
Searches for results and returns a \code{data.frame} with basic study information.
}
\examples{
# count trials satisfying 'heart disease AND stroke AND California'
\dontrun{clinicaltrials_search(query = 'heart disease AND stroke AND California')}

# advanced search for open, interventional trials involving melanoma
\dontrun{clinicaltrials_search(query = c('recr=Open', 'type=Intr', 'cond=melanoma'))}

# limit to 10 results
\dontrun{clinicaltrials_search(query = "colon cancer", count = 10)}
}

