/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib.query;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultVFAtomMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.DefaultVFBondMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.VFAtomMatcher;
import org.openscience.cdk.smsd.algorithm.matchers.VFBondMatcher;
import org.openscience.cdk.smsd.algorithm.vflib.builder.VFQueryBuilder;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQueryCompiler;

@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class QueryCompiler
implements IQueryCompiler {
    private IAtomContainer molecule = null;
    private IQueryAtomContainer queryMolecule = null;
    private boolean shouldMatchBonds = true;

    public QueryCompiler(IAtomContainer molecule, boolean shouldMatchBonds) {
        this.setMolecule(molecule);
        this.setBondMatchFlag(shouldMatchBonds);
    }

    public QueryCompiler(IQueryAtomContainer molecule) {
        this.setQueryMolecule(molecule);
    }

    private void setMolecule(IAtomContainer molecule) {
        this.molecule = molecule;
    }

    private void setQueryMolecule(IQueryAtomContainer molecule) {
        this.queryMolecule = molecule;
    }

    private IAtomContainer getMolecule() {
        return this.queryMolecule == null ? this.molecule : this.queryMolecule;
    }

    @Override
    public IQuery compile() {
        return this.queryMolecule == null ? this.build(this.molecule) : this.build(this.queryMolecule);
    }

    private IQuery build(IAtomContainer queryMolecule) {
        VFQueryBuilder result = new VFQueryBuilder();
        for (IAtom atom : queryMolecule.atoms()) {
            VFAtomMatcher matcher = this.createAtomMatcher(queryMolecule, atom);
            if (matcher == null) continue;
            result.addNode(matcher, atom);
        }
        for (int i = 0; i < queryMolecule.getBondCount(); ++i) {
            IBond bond = queryMolecule.getBond(i);
            IAtom atomI = bond.getAtom(0);
            IAtom atomJ = bond.getAtom(1);
            result.connect(result.getNode(atomI), result.getNode(atomJ), this.createBondMatcher(queryMolecule, bond));
        }
        return result;
    }

    private IQuery build(IQueryAtomContainer queryMolecule) {
        VFQueryBuilder result = new VFQueryBuilder();
        for (IAtom atoms : queryMolecule.atoms()) {
            IQueryAtom atom = (IQueryAtom)atoms;
            VFAtomMatcher matcher = this.createAtomMatcher(atom, queryMolecule);
            if (matcher == null) continue;
            result.addNode(matcher, (IAtom)atom);
        }
        for (int i = 0; i < queryMolecule.getBondCount(); ++i) {
            IBond bond = queryMolecule.getBond(i);
            IQueryAtom atomI = (IQueryAtom)bond.getAtom(0);
            IQueryAtom atomJ = (IQueryAtom)bond.getAtom(1);
            result.connect(result.getNode((IAtom)atomI), result.getNode((IAtom)atomJ), this.createBondMatcher((IQueryBond)bond));
        }
        return result;
    }

    private VFAtomMatcher createAtomMatcher(IAtomContainer mol, IAtom atom) {
        return new DefaultVFAtomMatcher(mol, atom, this.isBondMatchFlag());
    }

    private VFBondMatcher createBondMatcher(IAtomContainer mol, IBond bond) {
        return new DefaultVFBondMatcher(mol, bond, this.isBondMatchFlag());
    }

    private VFAtomMatcher createAtomMatcher(IQueryAtom atom, IQueryAtomContainer container) {
        return new DefaultVFAtomMatcher(atom, container);
    }

    private VFBondMatcher createBondMatcher(IQueryBond bond) {
        return new DefaultVFBondMatcher(bond);
    }

    private boolean isBondMatchFlag() {
        return this.shouldMatchBonds;
    }

    private void setBondMatchFlag(boolean shouldMatchBonds) {
        this.shouldMatchBonds = shouldMatchBonds;
    }
}

