/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers.smarts;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.ringsearch.RingSearch;

@TestClass(value="org.openscience.cdk.isomorphism.matchers.smarts.DaylightSMARTSAtomInvariantsTest")
final class SMARTSAtomInvariants {
    static String KEY = "SMARTS.INVARIANTS";
    private final IAtomContainer target;
    private final int valence;
    private final int ringNumber;
    private final Set<Integer> ringSize;
    private final int connectivity;
    private final int ringConnectivity;
    private final int degree;
    private final int totalHydrogenCount;

    SMARTSAtomInvariants(IAtomContainer target, int valence, int ringNumber, Set<Integer> ringSize, int ringConnectivity, int degree, int connectivity, int totalHydrogenCount) {
        this.target = target;
        this.valence = valence;
        this.ringNumber = ringNumber;
        this.ringSize = ringSize;
        this.connectivity = connectivity;
        this.totalHydrogenCount = totalHydrogenCount;
        this.ringConnectivity = ringConnectivity;
        this.degree = degree;
    }

    @TestMethod(value="target")
    IAtomContainer target() {
        return this.target;
    }

    @TestMethod(value="valence")
    int valence() {
        return this.valence;
    }

    @TestMethod(value="ringNumber,ringNumber_cyclophane")
    int ringNumber() {
        return this.ringNumber;
    }

    @TestMethod(value="ringSize,ringSize_cyclophane,ringSize_imidazole")
    Set<Integer> ringSize() {
        return this.ringSize;
    }

    @TestMethod(value="ringConnectivity")
    int ringConnectivity() {
        return this.ringConnectivity;
    }

    @TestMethod(value="connectivity")
    int connectivity() {
        return this.connectivity;
    }

    @TestMethod(value="degree")
    int degree() {
        return this.degree;
    }

    @TestMethod(value="totalHydrogenCount")
    int totalHydrogenCount() {
        return this.totalHydrogenCount;
    }

    @TestMethod(value="noRingInfo")
    static void configureDaylightWithoutRingInfo(IAtomContainer container) {
        GraphUtil.EdgeToBondMap map = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)container);
        int[][] graph = GraphUtil.toAdjList((IAtomContainer)container, (GraphUtil.EdgeToBondMap)map);
        SMARTSAtomInvariants.configureDaylight(container, graph, map, false);
    }

    @TestMethod(value="valence,degree")
    static void configureDaylightWithRingInfo(IAtomContainer container) {
        GraphUtil.EdgeToBondMap map = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)container);
        int[][] graph = GraphUtil.toAdjList((IAtomContainer)container, (GraphUtil.EdgeToBondMap)map);
        SMARTSAtomInvariants.configureDaylight(container, graph, map, true);
    }

    private static void configureDaylight(IAtomContainer container, int[][] graph, GraphUtil.EdgeToBondMap bondMap, boolean ringInfo) {
        int nAtoms = container.getAtomCount();
        int[] ringNumber = new int[nAtoms];
        int[] ringSize = new int[nAtoms];
        Arrays.fill(ringSize, nAtoms + 1);
        if (ringInfo) {
            for (int[] cycle : Cycles.sssr((IAtomContainer)container).paths()) {
                int size = cycle.length - 1;
                for (int i = 1; i < cycle.length; ++i) {
                    int v = cycle[i];
                    if (size < ringSize[v]) {
                        ringSize[v] = size;
                    }
                    int n = v;
                    ringNumber[n] = ringNumber[n] + 1;
                    bondMap.get(cycle[i], cycle[i - 1]).setFlag(2, true);
                }
            }
        } else {
            for (IBond bond : new RingSearch(container, graph).ringFragments().bonds()) {
                bond.setFlag(2, true);
            }
        }
        for (int v = 0; v < nAtoms; ++v) {
            int implHCount;
            IAtom atom = container.getAtom(v);
            int totalHCount = implHCount = ((Integer)Preconditions.checkNotNull((Object)atom.getImplicitHydrogenCount(), (Object)"Implicit hydrogen count was not set.")).intValue();
            int valence = implHCount;
            int degree = 0;
            int ringConnections = 0;
            for (int w : graph[v]) {
                IBond bond = bondMap.get(v, w);
                IBond.Order order = bond.getOrder();
                if (order == null || order == IBond.Order.UNSET) {
                    throw new NullPointerException("Bond order was not set.");
                }
                valence += order.numeric().intValue();
                ++degree;
                if (bond.getFlag(2)) {
                    ++ringConnections;
                }
                if (container.getAtom(w).getAtomicNumber() != 1) continue;
                ++totalHCount;
            }
            SMARTSAtomInvariants inv = new SMARTSAtomInvariants(container, valence, ringNumber[v], ringSize[v] <= nAtoms ? Collections.singleton(ringSize[v]) : Collections.emptySet(), ringConnections, degree, degree + implHCount, totalHCount);
            atom.setProperty((Object)KEY, (Object)inv);
        }
    }
}

