/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import nu.xom.Attribute;
import nu.xom.Element;
import nu.xom.Elements;
import org.openscience.cdk.IImplementationSpecification;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.dict.Dictionary;
import org.openscience.cdk.dict.DictionaryDatabase;
import org.openscience.cdk.dict.Entry;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IAtomicDescriptor;
import org.openscience.cdk.qsar.IBondDescriptor;
import org.openscience.cdk.qsar.IDescriptor;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.qsar.DescriptorEngineTest")
public class DescriptorEngine {
    private static String rdfNS = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private Dictionary dict = null;
    private List<String> classNames = new ArrayList<String>(200);
    private List<IDescriptor> descriptors = new ArrayList<IDescriptor>(200);
    private List<IImplementationSpecification> speclist = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(DescriptorEngine.class);
    private final IChemObjectBuilder builder;

    public DescriptorEngine(List<String> classNames, IChemObjectBuilder builder) {
        this.classNames = classNames;
        this.builder = builder;
        this.descriptors = this.instantiateDescriptors(classNames);
        this.speclist = this.initializeSpecifications(this.descriptors);
        DictionaryDatabase dictDB = new DictionaryDatabase();
        this.dict = dictDB.getDictionary("descriptor-algorithms");
    }

    @TestMethod(value="testConstructor")
    public DescriptorEngine(Class<? extends IDescriptor> c, IChemObjectBuilder builder) {
        for (IDescriptor iDescriptor : ServiceLoader.load(c)) {
            iDescriptor.initialise(builder);
            this.descriptors.add(iDescriptor);
            this.classNames.add(iDescriptor.getClass().getName());
        }
        this.builder = builder;
        this.speclist = this.initializeSpecifications(this.descriptors);
        logger.debug("Found #descriptors: ", this.classNames.size());
        DictionaryDatabase dictDB = new DictionaryDatabase();
        this.dict = dictDB.getDictionary("descriptor-algorithms");
    }

    public void process(IAtomContainer molecule) throws CDKException {
        if (this.descriptors == null || this.speclist == null) {
            throw new CDKException("Descriptors have not been instantiated");
        }
        if (this.speclist.size() != this.descriptors.size()) {
            throw new CDKException("Number of specs and descriptors do not match");
        }
        for (int i = 0; i < this.descriptors.size(); ++i) {
            DescriptorValue value;
            IDescriptor descriptor = this.descriptors.get(i);
            if (descriptor instanceof IMolecularDescriptor) {
                DescriptorValue value2 = ((IMolecularDescriptor)descriptor).calculate(molecule);
                if (value2.getException() == null) {
                    molecule.setProperty(this.speclist.get(i), value2);
                } else {
                    logger.error("Could not calculate descriptor value for: ", descriptor.getClass().getName());
                    logger.debug(value2.getException());
                }
                logger.debug("Calculated molecular descriptors...");
                continue;
            }
            if (descriptor instanceof IAtomicDescriptor) {
                for (IAtom atom : molecule.atoms()) {
                    value = ((IAtomicDescriptor)descriptor).calculate(atom, molecule);
                    if (value.getException() == null) {
                        atom.setProperty(this.speclist.get(i), value);
                        continue;
                    }
                    logger.error("Could not calculate descriptor value for: ", descriptor.getClass().getName());
                    logger.debug(value.getException());
                }
                logger.debug("Calculated atomic descriptors...");
                continue;
            }
            if (descriptor instanceof IBondDescriptor) {
                for (IBond bond : molecule.bonds()) {
                    value = ((IBondDescriptor)descriptor).calculate(bond, molecule);
                    if (value.getException() == null) {
                        bond.setProperty(this.speclist.get(i), value);
                        continue;
                    }
                    logger.error("Could not calculate descriptor value for: ", descriptor.getClass().getName());
                    logger.debug(value.getException());
                }
                logger.debug("Calculated bond descriptors...");
                continue;
            }
            logger.debug("Unknown descriptor type for: ", descriptor.getClass().getName());
        }
    }

    @TestMethod(value="testDictionaryType")
    public String getDictionaryType(String identifier) {
        Entry[] dictEntries = this.dict.getEntries();
        String specRef = this.getSpecRef(identifier);
        logger.debug("Got identifier: " + identifier);
        logger.debug("Final spec ref: " + specRef);
        for (Entry dictEntry : dictEntries) {
            if (!dictEntry.getClassName().equals("Descriptor") || !dictEntry.getID().equals(specRef.toLowerCase())) continue;
            Element rawElement = (Element)dictEntry.getRawContent();
            Elements classifications = rawElement.getChildElements("isClassifiedAs", this.dict.getNS());
            for (int i = 0; i < classifications.size(); ++i) {
                Element element = classifications.get(i);
                Attribute attr = element.getAttribute("resource", rdfNS);
                if (attr.getValue().indexOf("molecularDescriptor") == -1 && attr.getValue().indexOf("atomicDescriptor") == -1) continue;
                String[] tmp = attr.getValue().split("#");
                return tmp[1];
            }
        }
        return null;
    }

    @TestMethod(value="testDictionaryType")
    public String getDictionaryType(IImplementationSpecification descriptorSpecification) {
        return this.getDictionaryType(descriptorSpecification.getSpecificationReference());
    }

    @TestMethod(value="testDictionaryClass")
    public String[] getDictionaryClass(String identifier) {
        Entry[] dictEntries = this.dict.getEntries();
        String specRef = this.getSpecRef(identifier);
        if (specRef == null) {
            logger.error("Cannot determine specification for id: ", identifier);
            return new String[0];
        }
        ArrayList<String> dictClasses = new ArrayList<String>();
        for (Entry dictEntry : dictEntries) {
            if (!dictEntry.getClassName().equals("Descriptor") || !dictEntry.getID().equals(specRef.toLowerCase())) continue;
            Element rawElement = (Element)dictEntry.getRawContent();
            Elements classifications = rawElement.getChildElements("isClassifiedAs", this.dict.getNS());
            for (int i = 0; i < classifications.size(); ++i) {
                Element element = classifications.get(i);
                Attribute attr = element.getAttribute("resource", rdfNS);
                if (attr.getValue().indexOf("molecularDescriptor") >= 0 || attr.getValue().indexOf("atomicDescriptor") >= 0) continue;
                String[] tmp = attr.getValue().split("#");
                dictClasses.add(tmp[1]);
            }
        }
        if (dictClasses.size() == 0) {
            return null;
        }
        return dictClasses.toArray(new String[0]);
    }

    @TestMethod(value="testDictionaryClass")
    public String[] getDictionaryClass(IImplementationSpecification descriptorSpecification) {
        return this.getDictionaryClass(descriptorSpecification.getSpecificationReference());
    }

    public String getDictionaryDefinition(String identifier) {
        Entry[] dictEntries = this.dict.getEntries();
        String specRef = this.getSpecRef(identifier);
        if (specRef == null) {
            logger.error("Cannot determine specification for id: ", identifier);
            return "";
        }
        String definition = null;
        for (Entry dictEntry : dictEntries) {
            if (!dictEntry.getClassName().equals("Descriptor") || !dictEntry.getID().equals(specRef.toLowerCase())) continue;
            definition = dictEntry.getDefinition();
            break;
        }
        return definition;
    }

    public String getDictionaryDefinition(DescriptorSpecification descriptorSpecification) {
        return this.getDictionaryDefinition(descriptorSpecification.getSpecificationReference());
    }

    public String getDictionaryTitle(String identifier) {
        Entry[] dictEntries = this.dict.getEntries();
        String specRef = this.getSpecRef(identifier);
        if (specRef == null) {
            logger.error("Cannot determine specification for id: ", identifier);
            return "";
        }
        String title = null;
        for (Entry dictEntry : dictEntries) {
            if (!dictEntry.getClassName().equals("Descriptor") || !dictEntry.getID().equals(specRef.toLowerCase())) continue;
            title = dictEntry.getLabel();
            break;
        }
        return title;
    }

    public String getDictionaryTitle(DescriptorSpecification descriptorSpecification) {
        return this.getDictionaryTitle(descriptorSpecification.getSpecificationReference());
    }

    public List<IImplementationSpecification> getDescriptorSpecifications() {
        return this.speclist;
    }

    public void setDescriptorSpecifications(List<IImplementationSpecification> specs) {
        this.speclist = specs;
    }

    public List<String> getDescriptorClassNames() {
        return this.classNames;
    }

    @TestMethod(value="testLoadingOfMolecularDescriptors,testLoadingOfAtomicDescriptors,testLoadingOfBondDescriptors")
    public List<IDescriptor> getDescriptorInstances() {
        return this.descriptors;
    }

    public void setDescriptorInstances(List<IDescriptor> descriptors) {
        this.descriptors = descriptors;
    }

    @TestMethod(value="testAvailableClass")
    public String[] getAvailableDictionaryClasses() {
        ArrayList<String> classList = new ArrayList<String>();
        for (IImplementationSpecification spec : this.speclist) {
            String[] tmp = this.getDictionaryClass(spec);
            if (tmp == null) continue;
            classList.addAll(Arrays.asList(tmp));
        }
        HashSet uniqueClasses = new HashSet(classList);
        return uniqueClasses.toArray(new String[0]);
    }

    public static List<String> getDescriptorClassNameByInterface(String interfaceName, String[] jarFileNames) {
        String[] jars;
        if (interfaceName == null || interfaceName.equals("")) {
            interfaceName = "IDescriptor";
        }
        if (!(interfaceName.equals("IDescriptor") || interfaceName.equals("IMolecularDescriptor") || interfaceName.equals("IAtomicDescriptor") || interfaceName.equals("IBondDescriptor"))) {
            return null;
        }
        if (jarFileNames == null) {
            String classPath = System.getProperty("java.class.path");
            jars = classPath.split(File.pathSeparator);
        } else {
            jars = jarFileNames;
        }
        ArrayList<String> classlist = new ArrayList<String>();
        for (int i = 0; i < jars.length; ++i) {
            logger.debug("Looking in " + jars[i]);
            try {
                JarFile jarFile = new JarFile(jars[i]);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                block7: while (enumeration.hasMoreElements()) {
                    Class<?>[] interfaces;
                    int modifer;
                    String className;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (jarEntry.toString().indexOf(".class,") == -1 || (className = jarEntry.toString().replace('/', '.').replaceAll(".class,", "")).indexOf(36) != -1) continue;
                    Class<?> klass = null;
                    try {
                        klass = Class.forName(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        logger.debug(cnfe);
                    }
                    catch (NoClassDefFoundError ncdfe) {
                        logger.debug(ncdfe);
                    }
                    catch (UnsatisfiedLinkError ule) {
                        logger.debug(ule);
                    }
                    if (klass == null || Modifier.isAbstract(modifer = klass.getModifiers()) || Modifier.isInterface(modifer)) continue;
                    for (Class<?> anInterface : interfaces = klass.getInterfaces()) {
                        if (!anInterface.getName().equals(interfaceName)) continue;
                        classlist.add(className);
                        continue block7;
                    }
                }
                continue;
            }
            catch (IOException e) {
                logger.error("Error opening the jar file: " + jars[i]);
                logger.debug(e);
            }
        }
        return classlist;
    }

    public static List<String> getDescriptorClassNameByPackage(String packageName, String[] jarFileNames) {
        String[] jars;
        if (packageName == null || packageName.equals("")) {
            packageName = "org.openscience.cdk.qsar.descriptors";
        }
        if (jarFileNames == null) {
            String classPath = System.getProperty("java.class.path");
            logger.debug("Dictionary classpath: ", classPath);
            jars = classPath.split(File.pathSeparator);
        } else {
            jars = jarFileNames;
        }
        ArrayList<String> classlist = new ArrayList<String>();
        for (String jar : jars) {
            logger.debug("Looking in " + jar);
            try {
                JarFile jarFile = new JarFile(jar);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    String tmp;
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.toString().endsWith(".class") || (tmp = jarEntry.toString().replace('/', '.').replaceAll("\\.class", "")).indexOf(packageName) == -1 || tmp.indexOf(36) != -1 || tmp.indexOf("Test") != -1 || tmp.indexOf("ChiIndexUtils") != -1 || classlist.contains(tmp)) continue;
                    classlist.add(tmp);
                }
            }
            catch (IOException e) {
                logger.error("Error opening the jar file: " + jar);
                logger.debug(e);
            }
        }
        return classlist;
    }

    public List<IDescriptor> instantiateDescriptors(List<String> descriptorClassNames) {
        ArrayList<IDescriptor> descriptors = new ArrayList<IDescriptor>();
        ClassLoader classLoader = this.getClass().getClassLoader();
        for (String descriptorName : descriptorClassNames) {
            try {
                Class<?> c = classLoader.loadClass(descriptorName);
                IDescriptor descriptor = this.instantiate(c);
                descriptor.initialise(this.builder);
                descriptors.add(descriptor);
                logger.info("Loaded descriptor: ", descriptorName);
            }
            catch (NoClassDefFoundError error) {
                logger.error("Could not find this Descriptor: ", descriptorName);
                logger.debug(error);
            }
            catch (ClassNotFoundException exception) {
                logger.error("Could not find this Descriptor: ", descriptorName);
                logger.debug(exception);
            }
            catch (Exception exception) {
                logger.error("Could not load this Descriptor: ", descriptorName);
                logger.debug(exception);
            }
        }
        return descriptors;
    }

    private IDescriptor instantiate(Class<? extends IDescriptor> c) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        for (Constructor<?> constructor : c.getConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == 0) {
                return (IDescriptor)constructor.newInstance(new Object[0]);
            }
            if (params.length != 1 || !params[0].equals(IChemObjectBuilder.class)) continue;
            return (IDescriptor)constructor.newInstance(this.builder);
        }
        throw new IllegalStateException("descriptor " + c.getSimpleName() + " has no usable constructors");
    }

    public List<IImplementationSpecification> initializeSpecifications(List<IDescriptor> descriptors) {
        ArrayList<IImplementationSpecification> speclist = new ArrayList<IImplementationSpecification>();
        for (IDescriptor descriptor : descriptors) {
            speclist.add(descriptor.getSpecification());
        }
        return speclist;
    }

    private String getSpecRef(String identifier) {
        String specRef = null;
        for (int i = 0; i < this.classNames.size(); ++i) {
            String className = this.classNames.get(i);
            if (!className.equals(identifier)) continue;
            IDescriptor descriptor = this.descriptors.get(i);
            IImplementationSpecification descSpecification = descriptor.getSpecification();
            String[] tmp = descSpecification.getSpecificationReference().split("#");
            if (tmp.length != 2) {
                logger.debug("Something fishy with the spec ref: ", descSpecification.getSpecificationReference());
                continue;
            }
            specRef = tmp[1];
        }
        if (specRef == null) {
            String[] tmp = identifier.split("#");
            if (tmp.length != 2) {
                logger.debug("Something fishy with the identifier: ", identifier);
            } else {
                specRef = tmp[1];
            }
        }
        return specRef;
    }
}

