/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.AllCycles;
import org.openscience.cdk.graph.CycleFinder;
import org.openscience.cdk.graph.EdgeShortCycles;
import org.openscience.cdk.graph.EssentialCycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.InitialCycles;
import org.openscience.cdk.graph.MinimumCycleBasis;
import org.openscience.cdk.graph.RelevantCycles;
import org.openscience.cdk.graph.TripletShortCycles;
import org.openscience.cdk.graph.VertexShortCycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.RingSearch;

@TestClass(value="org.openscience.cdk.graph.CyclesTest")
public final class Cycles {
    private final int[][] paths;
    private final IAtomContainer container;
    private final GraphUtil.EdgeToBondMap bondMap;

    private Cycles(int[][] paths, IAtomContainer container, GraphUtil.EdgeToBondMap bondMap) {
        this.paths = paths;
        this.container = container;
        this.bondMap = bondMap;
    }

    @TestMethod(value="all,mcb,relevant,essential,tripletShort,vertexShort,edgeShort")
    public int numberOfCycles() {
        return this.paths.length;
    }

    @TestMethod(value="pathsAreCopy")
    public int[][] paths() {
        int[][] cpy = new int[this.paths.length][];
        for (int i = 0; i < this.paths.length; ++i) {
            cpy[i] = (int[])this.paths[i].clone();
        }
        return cpy;
    }

    @TestMethod(value="toRingSet")
    public IRingSet toRingSet() {
        return Cycles.toRingSet(this.container, this.paths, this.bondMap);
    }

    @TestMethod(value="all")
    public static CycleFinder all() {
        return CycleComputation.ALL;
    }

    @TestMethod(value="allUpToLength")
    public static CycleFinder all(int length) {
        return new AllUpToLength(length);
    }

    @TestMethod(value="mcb")
    public static CycleFinder mcb() {
        return CycleComputation.MCB;
    }

    @TestMethod(value="relevant")
    public static CycleFinder relevant() {
        return CycleComputation.RELEVANT;
    }

    @TestMethod(value="essential")
    public static CycleFinder essential() {
        return CycleComputation.ESSENTIAL;
    }

    @TestMethod(value="tripletShort")
    public static CycleFinder tripletShort() {
        return CycleComputation.TRIPLET_SHORT;
    }

    @TestMethod(value="vertexShort")
    public static CycleFinder vertexShort() {
        return CycleComputation.VERTEX_SHORT;
    }

    @TestMethod(value="edgeShort")
    public static CycleFinder edgeShort() {
        return CycleComputation.EDGE_SHORT;
    }

    @TestMethod(value="cdkAromaticSet")
    public static CycleFinder cdkAromaticSet() {
        return CycleComputation.CDK_AROMATIC;
    }

    @Deprecated
    @TestMethod(value="allOrVertexShort")
    public static CycleFinder allOrVertexShort() {
        return Cycles.or(Cycles.all(), Cycles.vertexShort());
    }

    @TestMethod(value="or")
    public static CycleFinder or(CycleFinder primary, CycleFinder auxiliary) {
        return new Fallback(primary, auxiliary);
    }

    @TestMethod(value="all")
    public static Cycles all(IAtomContainer container) throws Intractable {
        return Cycles.all().find(container, container.getAtomCount());
    }

    @TestMethod(value="allUpToLength")
    public static Cycles all(IAtomContainer container, int length) throws Intractable {
        return Cycles.all().find(container, length);
    }

    @TestMethod(value="mcb")
    public static Cycles mcb(IAtomContainer container) {
        return Cycles._invoke(Cycles.mcb(), container);
    }

    @TestMethod(value="mcb")
    public static Cycles sssr(IAtomContainer container) {
        return Cycles.mcb(container);
    }

    @TestMethod(value="relevant")
    public static Cycles relevant(IAtomContainer container) {
        return Cycles._invoke(Cycles.relevant(), container);
    }

    @TestMethod(value="essential")
    public static Cycles essential(IAtomContainer container) {
        return Cycles._invoke(Cycles.essential(), container);
    }

    @TestMethod(value="tripletShort")
    public static Cycles tripletShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.tripletShort(), container);
    }

    @TestMethod(value="vertexShort")
    public static Cycles vertexShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.vertexShort(), container);
    }

    @TestMethod(value="edgeShort")
    public static Cycles edgeShort(IAtomContainer container) {
        return Cycles._invoke(Cycles.edgeShort(), container);
    }

    @TestMethod(value="unchorded")
    public static CycleFinder unchorded(CycleFinder original) {
        return new Unchorded(original);
    }

    private static Cycles _invoke(CycleFinder finder, IAtomContainer container) {
        return Cycles._invoke(finder, container, container.getAtomCount());
    }

    private static Cycles _invoke(CycleFinder finder, IAtomContainer container, int length) {
        try {
            return finder.find(container, length);
        }
        catch (Intractable e) {
            throw new RuntimeException("Cycle computation should not be intractable: ", e);
        }
    }

    private static int[] lift(int[] path, int[] mapping) {
        for (int i = 0; i < path.length; ++i) {
            path[i] = mapping[path[i]];
        }
        return path;
    }

    private static IRingSet toRingSet(IAtomContainer container, int[][] cycles, GraphUtil.EdgeToBondMap bondMap) {
        IChemObjectBuilder builder = container.getBuilder();
        IRingSet rings = builder.newInstance(IRingSet.class, new Object[0]);
        for (int[] cycle : cycles) {
            rings.addAtomContainer(Cycles.toRing(container, cycle, bondMap));
        }
        return rings;
    }

    private static IRing toRing(IAtomContainer container, int[] cycle, GraphUtil.EdgeToBondMap bondMap) {
        IAtom[] atoms = new IAtom[cycle.length - 1];
        IBond[] bonds = new IBond[cycle.length - 1];
        for (int i = 1; i < cycle.length; ++i) {
            int v = cycle[i];
            int u = cycle[i - 1];
            atoms[i - 1] = container.getAtom(u);
            bonds[i - 1] = Cycles.getBond(container, bondMap, u, v);
        }
        IChemObjectBuilder builder = container.getBuilder();
        IAtomContainer ring = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        ring.setAtoms(atoms);
        ring.setBonds(bonds);
        return builder.newInstance(IRing.class, ring);
    }

    private static IBond getBond(IAtomContainer container, GraphUtil.EdgeToBondMap bondMap, int u, int v) {
        if (bondMap != null) {
            return bondMap.get(u, v);
        }
        return container.getBond(container.getAtom(u), container.getAtom(v));
    }

    private static final class Unchorded
    implements CycleFinder {
        private CycleFinder primary;

        private Unchorded(CycleFinder primary) {
            this.primary = primary;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            Cycles inital = this.primary.find(molecule, graph, length);
            int[][] filtered = new int[inital.numberOfCycles()][0];
            int n = 0;
            for (int[] path : inital.paths) {
                if (!this.accept(path, graph)) continue;
                filtered[n++] = path;
            }
            return new Cycles((int[][])Arrays.copyOf(filtered, n), inital.container, inital.bondMap);
        }

        private boolean accept(int[] path, int[][] graph) {
            BitSet vertices = new BitSet();
            for (int v : path) {
                vertices.set(v);
            }
            for (int j = 1; j < path.length; ++j) {
                int v = path[j];
                int prev = path[j - 1];
                int next = path[(j + 1) % (path.length - 1)];
                for (int w : graph[v]) {
                    if (w == prev || w == next || !vertices.get(w)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static final class Fallback
    implements CycleFinder {
        private CycleFinder primary;
        private CycleFinder auxiliary;

        private Fallback(CycleFinder primary, CycleFinder auxiliary) {
            this.primary = primary;
            this.auxiliary = auxiliary;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            try {
                return this.primary.find(molecule, graph, length);
            }
            catch (Intractable e) {
                return this.auxiliary.find(molecule, graph, length);
            }
        }
    }

    private static final class AllUpToLength
    implements CycleFinder {
        private final int predefinedLength;
        private final int threshold = 684;

        private AllUpToLength(int length) {
            this.predefinedLength = length;
        }

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            return this.find(molecule, GraphUtil.toAdjList(molecule), length);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            RingSearch ringSearch = new RingSearch(molecule, graph);
            if (this.predefinedLength < length) {
                length = this.predefinedLength;
            }
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                if (isolated.length > length) continue;
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.findInFused(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, null);
        }

        private int[][] findInFused(int[][] g, int length) throws Intractable {
            AllCycles allCycles = new AllCycles(g, Math.min(g.length, length), 684);
            if (!allCycles.completed()) {
                throw new Intractable("A large number of cycles were being generated and the computation was aborted. Please us AllCycles/AllRingsFinder with and specify a larger threshold or an alternative cycle set.");
            }
            return allCycles.paths();
        }
    }

    private static enum CycleComputation implements CycleFinder
    {
        MCB{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new MinimumCycleBasis(ic, true).paths();
            }
        }
        ,
        ESSENTIAL{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                RelevantCycles rc = new RelevantCycles(ic);
                return new EssentialCycles(rc, ic).paths();
            }
        }
        ,
        RELEVANT{

            @Override
            int[][] apply(int[][] graph, int length) {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new RelevantCycles(ic).paths();
            }
        }
        ,
        ALL{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                int threshold = 684;
                AllCycles ac = new AllCycles(graph, Math.min(length, graph.length), 684);
                if (!ac.completed()) {
                    throw new Intractable("A large number of cycles were being generated and the computation was aborted. Please use AllCycles/AllRingsFinder with and specify a larger threshold or use a CycleFinger with a fall-back to a set unique cycles: e.g. Cycles.allOrVertexShort().");
                }
                return ac.paths();
            }
        }
        ,
        TRIPLET_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new TripletShortCycles(new MinimumCycleBasis(ic, true), false).paths();
            }
        }
        ,
        VERTEX_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new VertexShortCycles(ic).paths();
            }
        }
        ,
        EDGE_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                return new EdgeShortCycles(ic).paths();
            }
        }
        ,
        CDK_AROMATIC{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                InitialCycles ic = InitialCycles.ofBiconnectedComponent(graph, length);
                MinimumCycleBasis mcb = new MinimumCycleBasis(ic, true);
                if (mcb.size() > 3) {
                    return mcb.paths();
                }
                return ALL.apply(graph, length);
            }
        }
        ,
        ALL_OR_VERTEX_SHORT{

            @Override
            int[][] apply(int[][] graph, int length) throws Intractable {
                int threshold = 684;
                AllCycles ac = new AllCycles(graph, Math.min(length, graph.length), 684);
                return ac.completed() ? ac.paths() : VERTEX_SHORT.apply(graph, length);
            }
        };


        abstract int[][] apply(int[][] var1, int var2) throws Intractable;

        @Override
        public Cycles find(IAtomContainer molecule) throws Intractable {
            return this.find(molecule, molecule.getAtomCount());
        }

        @Override
        public Cycles find(IAtomContainer molecule, int length) throws Intractable {
            GraphUtil.EdgeToBondMap bondMap = GraphUtil.EdgeToBondMap.withSpaceFor(molecule);
            int[][] graph = GraphUtil.toAdjList(molecule, bondMap);
            RingSearch ringSearch = new RingSearch(molecule, graph);
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                if (isolated.length > length) continue;
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.apply(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, bondMap);
        }

        @Override
        public Cycles find(IAtomContainer molecule, int[][] graph, int length) throws Intractable {
            RingSearch ringSearch = new RingSearch(molecule, graph);
            ArrayList<int[]> walks = new ArrayList<int[]>(6);
            for (int[] isolated : ringSearch.isolated()) {
                walks.add(GraphUtil.cycle(graph, isolated));
            }
            for (int[] fused : ringSearch.fused()) {
                for (int[] cycle : this.apply(GraphUtil.subgraph(graph, fused), length)) {
                    walks.add(Cycles.lift(cycle, fused));
                }
            }
            return new Cycles((int[][])walks.toArray((T[])new int[walks.size()][0]), molecule, null);
        }
    }
}

