/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.labelling;

import java.util.Iterator;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.labelling.Permutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomContainerAtomPermutor
extends Permutor
implements Iterator<IAtomContainer> {
    private IAtomContainer original;

    public AtomContainerAtomPermutor(IAtomContainer atomContainer) {
        super(atomContainer.getAtomCount());
        this.original = atomContainer;
    }

    @Override
    public IAtomContainer next() {
        int[] p = super.getNextPermutation();
        return AtomContainerAtomPermutor.permute(p, this.original);
    }

    public static IAtomContainer permute(int[] p, IAtomContainer atomContainer) {
        boolean useA = false;
        if (useA) {
            return AtomContainerAtomPermutor.permuteA(p, atomContainer);
        }
        return AtomContainerAtomPermutor.permuteB(p, atomContainer);
    }

    private static IAtomContainer permuteA(int[] p, IAtomContainer atomContainer) {
        IAtomContainer permutedContainer = null;
        try {
            permutedContainer = atomContainer.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
            for (int i = 0; i < p.length; ++i) {
                IAtom atom = atomContainer.getAtom(p[i]);
                permutedContainer.addAtom((IAtom)atom.clone());
            }
            for (IBond bond : atomContainer.bonds()) {
                IBond clonedBond = (IBond)bond.clone();
                clonedBond.setAtoms(new IAtom[clonedBond.getAtomCount()]);
                int i = 0;
                for (IAtom atom : bond.atoms()) {
                    int index = atomContainer.getAtomNumber(atom);
                    IAtom permutedAtom = permutedContainer.getAtom(p[index]);
                    clonedBond.setAtom(permutedAtom, i++);
                }
                permutedContainer.addBond(clonedBond);
            }
        }
        catch (CloneNotSupportedException cne) {
            System.out.println(cne);
        }
        return permutedContainer;
    }

    private static IAtomContainer permuteB(int[] p, IAtomContainer atomContainer) {
        IAtomContainer permutedContainer = null;
        try {
            permutedContainer = atomContainer.clone();
            int n = atomContainer.getAtomCount();
            IAtom[] permutedAtoms = new IAtom[n];
            for (int originalIndex = 0; originalIndex < n; ++originalIndex) {
                IAtom atom = permutedContainer.getAtom(originalIndex);
                int newIndex = p[originalIndex];
                permutedAtoms[newIndex] = atom;
            }
            permutedContainer.setAtoms(permutedAtoms);
        }
        catch (CloneNotSupportedException cne) {
            System.out.println(cne);
        }
        return permutedContainer;
    }

    @Override
    public void remove() {
    }
}

