/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.isotopes.IsotopeReader;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

@TestClass(value="org.openscience.cdk.config.IsotopeFactoryTest")
public class IsotopeFactory {
    private static IsotopeFactory ifac = null;
    private List<IIsotope> isotopes = null;
    private HashMap<String, IIsotope> majorIsotopes = null;
    private boolean debug = false;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(IsotopeFactory.class);

    private IsotopeFactory(IChemObjectBuilder builder) throws IOException {
        InputStream ins;
        logger.info("Creating new IsotopeFactory");
        String errorMessage = "There was a problem getting org.openscience.cdk.config.isotopes.xml as a stream";
        try {
            String configFile = "org/openscience/cdk/config/data/isotopes.xml";
            if (this.debug) {
                logger.debug("Getting stream for ", configFile);
            }
            ins = this.getClass().getClassLoader().getResourceAsStream(configFile);
        }
        catch (Exception exception) {
            logger.error(errorMessage);
            logger.debug(exception);
            throw new IOException(errorMessage);
        }
        if (ins == null) {
            logger.error(errorMessage);
            throw new IOException(errorMessage);
        }
        IsotopeReader reader = new IsotopeReader(ins, builder);
        this.isotopes = reader.readIsotopes();
        if (this.debug) {
            logger.debug("Found #isotopes in file: ", this.isotopes.size());
        }
        this.majorIsotopes = new HashMap();
    }

    @TestMethod(value="testGetInstance_IChemObjectBuilder")
    public static IsotopeFactory getInstance(IChemObjectBuilder builder) throws IOException {
        if (ifac == null) {
            ifac = new IsotopeFactory(builder);
        }
        return ifac;
    }

    @TestMethod(value="testGetSize")
    public int getSize() {
        return this.isotopes.size();
    }

    @TestMethod(value="testGetIsotopes_String")
    public IIsotope[] getIsotopes(String symbol) {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : this.isotopes) {
            if (!isotope.getSymbol().equals(symbol)) continue;
            try {
                IIsotope clone = (IIsotope)isotope.clone();
                list.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @TestMethod(value="testGetIsotopes")
    public IIsotope[] getIsotopes() {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : this.isotopes) {
            try {
                IIsotope clone = (IIsotope)isotope.clone();
                list.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @TestMethod(value="testGetIsotopes_double_double")
    public IIsotope[] getIsotopes(double exactMass, double difference) {
        ArrayList<IIsotope> list = new ArrayList<IIsotope>();
        for (IIsotope isotope : this.isotopes) {
            if (!(Math.abs(isotope.getExactMass() - exactMass) <= difference)) continue;
            try {
                IIsotope clone = (IIsotope)isotope.clone();
                list.add(clone);
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return list.toArray(new IIsotope[list.size()]);
    }

    @TestMethod(value="testGetIsotope")
    public IIsotope getIsotope(String symbol, int massNumber) {
        IIsotope ret = null;
        for (IIsotope isotope : this.isotopes) {
            if (!isotope.getSymbol().equals(symbol) || isotope.getMassNumber() != massNumber) continue;
            try {
                ret = (IIsotope)isotope.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
            return ret;
        }
        return null;
    }

    @TestMethod(value="testGetIsotopeFromExactMass")
    public IIsotope getIsotope(String symbol, double exactMass, double tolerance) {
        IIsotope ret = null;
        double minDiff = Double.MAX_VALUE;
        for (IIsotope isotope : this.isotopes) {
            double diff = Math.abs(isotope.getExactMass() - exactMass);
            if (!isotope.getSymbol().equals(symbol) || !(diff <= tolerance) || !(diff < minDiff)) continue;
            try {
                ret = (IIsotope)isotope.clone();
                minDiff = diff;
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        return ret;
    }

    @TestMethod(value="testGetMajorIsotope_int")
    public IIsotope getMajorIsotope(int atomicNumber) {
        IIsotope major = null;
        for (IIsotope isotope : this.isotopes) {
            if (isotope.getAtomicNumber() != atomicNumber) continue;
            try {
                if (major == null) {
                    major = (IIsotope)isotope.clone();
                    continue;
                }
                if (!(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                major = (IIsotope)isotope.clone();
            }
            catch (CloneNotSupportedException e) {
                logger.error("Could not clone IIsotope: ", e.getMessage());
                logger.debug(e);
            }
        }
        if (major == null) {
            logger.error("Could not find major isotope for: ", atomicNumber);
        }
        return major;
    }

    @TestMethod(value="testIsElement_String")
    public boolean isElement(String elementName) {
        return this.getElement(elementName) != null;
    }

    @TestMethod(value="testGetMajorIsotope_String")
    public IIsotope getMajorIsotope(String symbol) {
        IIsotope major = null;
        if (this.majorIsotopes.containsKey(symbol)) {
            major = this.majorIsotopes.get(symbol);
        } else {
            for (IIsotope isotope : this.isotopes) {
                if (!isotope.getSymbol().equals(symbol)) continue;
                try {
                    if (major == null) {
                        major = (IIsotope)isotope.clone();
                        continue;
                    }
                    if (!(isotope.getNaturalAbundance() > major.getNaturalAbundance())) continue;
                    major = (IIsotope)isotope.clone();
                }
                catch (CloneNotSupportedException e) {
                    logger.error("Could not clone IIsotope: ", e.getMessage());
                    logger.debug(e);
                }
            }
            if (major == null) {
                logger.error("Could not find major isotope for: ", symbol);
            } else {
                this.majorIsotopes.put(symbol, major);
            }
        }
        return major;
    }

    @TestMethod(value="testGetElement_String")
    public IElement getElement(String symbol) {
        return this.getMajorIsotope(symbol);
    }

    @TestMethod(value="testGetElement_int")
    public IElement getElement(int atomicNumber) {
        return this.getMajorIsotope(atomicNumber);
    }

    @TestMethod(value="testGetElementSymbol_int")
    public String getElementSymbol(int atomicNumber) {
        IIsotope isotope = this.getMajorIsotope(atomicNumber);
        return isotope.getSymbol();
    }

    @TestMethod(value="testConfigure_IAtom")
    public IAtom configure(IAtom atom) {
        IIsotope isotope = atom.getMassNumber() == null ? this.getMajorIsotope(atom.getSymbol()) : this.getIsotope(atom.getSymbol(), atom.getMassNumber());
        if (isotope == null) {
            throw new IllegalArgumentException("Cannot configure an unrecognized element: " + atom);
        }
        return this.configure(atom, isotope);
    }

    @TestMethod(value="testConfigure_IAtom_IIsotope")
    public IAtom configure(IAtom atom, IIsotope isotope) {
        atom.setMassNumber(isotope.getMassNumber());
        atom.setSymbol(isotope.getSymbol());
        atom.setExactMass(isotope.getExactMass());
        atom.setAtomicNumber(isotope.getAtomicNumber());
        atom.setNaturalAbundance(isotope.getNaturalAbundance());
        return atom;
    }

    @TestMethod(value="testConfigureAtoms_IAtomContainer")
    public void configureAtoms(IAtomContainer container) {
        for (int f = 0; f < container.getAtomCount(); ++f) {
            this.configure(container.getAtom(f));
        }
    }

    @TestMethod(value="testGetNaturalMass_IElement")
    public double getNaturalMass(IElement element) {
        IIsotope[] isotopes = this.getIsotopes(element.getSymbol());
        double summedAbundances = 0.0;
        double summedWeightedAbundances = 0.0;
        double getNaturalMass = 0.0;
        for (int i = 0; i < isotopes.length; ++i) {
            getNaturalMass = (summedWeightedAbundances += isotopes[i].getNaturalAbundance() * isotopes[i].getExactMass()) / (summedAbundances += isotopes[i].getNaturalAbundance().doubleValue());
        }
        return getNaturalMass;
    }
}

