/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.layout;

import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point2d;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.stereo.ExtendedTetrahedral;
import org.openscience.cdk.tools.LoggingToolFactory;

final class NonplanarBonds {
    private final IAtomContainer container;
    private final int[][] graph;
    private final RingSearch ringSearch;
    private final ITetrahedralChirality[] tetrahedralElements;
    private final IDoubleBondStereochemistry[] doubleBondElements;
    private final Map<IAtom, Integer> atomToIndex;
    private final GraphUtil.EdgeToBondMap edgeToBond;

    public static IAtomContainer assign(IAtomContainer container) {
        GraphUtil.EdgeToBondMap edgeToBond = GraphUtil.EdgeToBondMap.withSpaceFor(container);
        new NonplanarBonds(container, GraphUtil.toAdjList(container, edgeToBond), edgeToBond);
        return container;
    }

    NonplanarBonds(IAtomContainer container, int[][] g, GraphUtil.EdgeToBondMap edgeToBond) {
        this.container = container;
        this.tetrahedralElements = new ITetrahedralChirality[container.getAtomCount()];
        this.doubleBondElements = new IDoubleBondStereochemistry[container.getAtomCount()];
        this.graph = g;
        this.atomToIndex = Maps.newHashMapWithExpectedSize(container.getAtomCount());
        this.edgeToBond = edgeToBond;
        this.ringSearch = new RingSearch(container, this.graph);
        for (IBond bond : container.bonds()) {
            switch (bond.getStereo()) {
                case UP: 
                case UP_INVERTED: 
                case DOWN: 
                case DOWN_INVERTED: {
                    bond.setStereo(IBond.Stereo.NONE);
                }
            }
        }
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            this.atomToIndex.put(atom, i);
            if (atom.getPoint2d() != null) continue;
            throw new IllegalArgumentException("atom " + i + " had unset coordinates");
        }
        Integer[] foci = new Integer[container.getAtomCount()];
        int n = 0;
        for (IStereoElement element : container.stereoElements()) {
            if (element instanceof ITetrahedralChirality) {
                ITetrahedralChirality tc = (ITetrahedralChirality)element;
                int focus = this.atomToIndex.get(tc.getChiralAtom());
                this.tetrahedralElements[focus] = tc;
                foci[n++] = focus;
                continue;
            }
            if (!(element instanceof IDoubleBondStereochemistry)) continue;
            IBond doubleBond = ((IDoubleBondStereochemistry)element).getStereoBond();
            IDoubleBondStereochemistry iDoubleBondStereochemistry = (IDoubleBondStereochemistry)element;
            this.doubleBondElements[this.atomToIndex.get((Object)doubleBond.getAtom((int)1)).intValue()] = iDoubleBondStereochemistry;
            this.doubleBondElements[this.atomToIndex.get((Object)doubleBond.getAtom((int)0)).intValue()] = iDoubleBondStereochemistry;
        }
        Arrays.sort(foci, 0, n, new Comparator<Integer>(){

            @Override
            public int compare(Integer i, Integer j) {
                return -Ints.compare(NonplanarBonds.this.nAdjacentCentres(i), NonplanarBonds.this.nAdjacentCentres(j));
            }
        });
        for (int i = 0; i < n; ++i) {
            this.label(this.tetrahedralElements[foci[i]]);
        }
        for (IStereoElement se : container.stereoElements()) {
            if (!(se instanceof ExtendedTetrahedral)) continue;
            this.label((ExtendedTetrahedral)se);
        }
        for (IBond bond : this.findUnspecifiedDoubleBonds(g)) {
            this.labelUnspecified(bond);
        }
    }

    private void label(ExtendedTetrahedral element) {
        IAtom focus = element.focus();
        IAtom[] atoms = element.peripherals();
        IBond[] bonds = new IBond[4];
        int p = this.parity(element.winding());
        List<IBond> focusBonds = this.container.getConnectedBondsList(focus);
        if (focusBonds.size() != 2) {
            LoggingToolFactory.createLoggingTool(this.getClass()).warn("Non-cumulated carbon presented as the focus of extended tetrahedral stereo configuration");
            return;
        }
        IAtom[] terminals = element.findTerminalAtoms(this.container);
        IAtom left = terminals[0];
        IAtom right = terminals[1];
        bonds[0] = this.container.getBond(left, atoms[0]);
        bonds[1] = this.container.getBond(left, atoms[1]);
        bonds[2] = this.container.getBond(right, atoms[2]);
        bonds[3] = this.container.getBond(right, atoms[3]);
        int[] rank = new int[4];
        for (int i = 0; i < 4; ++i) {
            rank[i] = i;
        }
        p *= this.sortClockwise(rank, focus, atoms, 4);
        IBond.Stereo[] labels = new IBond.Stereo[4];
        for (int i = 0; i < 4; ++i) {
            int v = rank[i];
            labels[v] = (p *= -1) > 0 ? IBond.Stereo.UP : IBond.Stereo.DOWN;
        }
        int[] priority = new int[]{5, 5, 5, 5};
        int i = 0;
        for (int v : this.priority(this.atomToIndex.get(focus), atoms, 4)) {
            IBond bond = bonds[v];
            if (bond == null || bond.getStereo() != IBond.Stereo.NONE || bond.getOrder() != IBond.Order.SINGLE) continue;
            priority[v] = i++;
        }
        if (priority[0] + priority[1] < priority[2] + priority[3]) {
            if (priority[0] < 5) {
                bonds[0].setAtoms(new IAtom[]{left, atoms[0]});
                bonds[0].setStereo(labels[0]);
            }
            if (priority[1] < 5) {
                bonds[1].setAtoms(new IAtom[]{left, atoms[1]});
                bonds[1].setStereo(labels[1]);
            }
        } else {
            if (priority[2] < 5) {
                bonds[2].setAtoms(new IAtom[]{right, atoms[2]});
                bonds[2].setStereo(labels[2]);
            }
            if (priority[3] < 5) {
                bonds[3].setAtoms(new IAtom[]{right, atoms[3]});
                bonds[3].setStereo(labels[3]);
            }
        }
    }

    private void label(ITetrahedralChirality element) {
        IAtom focus = element.getChiralAtom();
        IAtom[] atoms = element.getLigands();
        IBond[] bonds = new IBond[4];
        int p = this.parity(element.getStereo());
        int n = 0;
        if (p == 0) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            if (atoms[i] == focus) {
                p *= this.parity(i);
                continue;
            }
            bonds[n] = this.container.getBond(focus, atoms[i]);
            atoms[n] = atoms[i];
            ++n;
        }
        int[] rank = new int[n];
        for (int i = 0; i < n; ++i) {
            rank[i] = i;
        }
        p *= this.sortClockwise(rank, focus, atoms, n);
        int invert = -1;
        if (n == 3) {
            for (int i = 0; i < n; ++i) {
                Point2d a = atoms[rank[i]].getPoint2d();
                Point2d b = focus.getPoint2d();
                Point2d c = atoms[rank[(i + 2) % n]].getPoint2d();
                double det = (a.x - c.x) * (b.y - c.y) - (a.y - c.y) * (b.x - c.x);
                if (!(det > 0.0)) continue;
                invert = rank[(i + 1) % n];
                break;
            }
        }
        IBond.Stereo[] labels = new IBond.Stereo[n];
        for (int i = 0; i < n; ++i) {
            int v = rank[i];
            if (n == 4) {
                p *= -1;
            }
            labels[v] = invert == v ? (p > 0 ? IBond.Stereo.DOWN : IBond.Stereo.UP) : (p > 0 ? IBond.Stereo.UP : IBond.Stereo.DOWN);
        }
        for (int v : this.priority(this.atomToIndex.get(focus), atoms, n)) {
            IBond bond = bonds[v];
            if (bond.getStereo() != IBond.Stereo.NONE || bond.getOrder() != IBond.Order.SINGLE) continue;
            bond.setAtoms(new IAtom[]{focus, atoms[v]});
            bond.setStereo(labels[v]);
            return;
        }
        throw new IllegalArgumentException("could not assign non-planar (up/down) labels");
    }

    private int parity(int x) {
        return (x & 1) == 1 ? -1 : 1;
    }

    private int parity(ITetrahedralChirality.Stereo stereo) {
        switch (stereo) {
            case CLOCKWISE: {
                return -1;
            }
            case ANTI_CLOCKWISE: {
                return 1;
            }
        }
        return 0;
    }

    private int nAdjacentCentres(int i) {
        int n = 0;
        for (IAtom atom : this.tetrahedralElements[i].getLigands()) {
            if (this.tetrahedralElements[this.atomToIndex.get(atom)] == null) continue;
            ++n;
        }
        return n;
    }

    private int[] priority(int focus, IAtom[] atoms, int n) {
        int[] rank = new int[n];
        for (int i = 0; i < n; ++i) {
            rank[i] = i;
        }
        for (int j = 1; j < n; ++j) {
            int v = rank[j];
            int i = j - 1;
            while (i >= 0 && this.hasPriority(focus, this.atomToIndex.get(atoms[v]), this.atomToIndex.get(atoms[rank[i]]))) {
                rank[i + 1] = rank[i--];
            }
            rank[i + 1] = v;
        }
        return rank;
    }

    boolean hasPriority(int focus, int i, int j) {
        boolean jCyclic;
        if (this.tetrahedralElements[i] == null && this.tetrahedralElements[j] != null) {
            return true;
        }
        if (this.tetrahedralElements[i] != null && this.tetrahedralElements[j] == null) {
            return false;
        }
        if (this.doubleBondElements[i] == null && this.doubleBondElements[j] != null) {
            return true;
        }
        if (this.doubleBondElements[i] != null && this.doubleBondElements[j] == null) {
            return false;
        }
        boolean iCyclic = focus >= 0 ? this.ringSearch.cyclic(focus, i) : this.ringSearch.cyclic(i);
        boolean bl = jCyclic = focus >= 0 ? this.ringSearch.cyclic(focus, j) : this.ringSearch.cyclic(j);
        if (!iCyclic && jCyclic) {
            return true;
        }
        if (iCyclic && !jCyclic) {
            return false;
        }
        if (this.container.getAtom(i).getAtomicNumber() > 0 && this.container.getAtom(j).getAtomicNumber() == 0) {
            return true;
        }
        if (this.container.getAtom(i).getAtomicNumber() == 0 && this.container.getAtom(j).getAtomicNumber() > 0) {
            return false;
        }
        if (this.graph[i].length < this.graph[j].length) {
            return true;
        }
        if (this.graph[i].length > this.graph[j].length) {
            return false;
        }
        if (this.container.getAtom(i).getAtomicNumber() < this.container.getAtom(j).getAtomicNumber()) {
            return true;
        }
        if (this.container.getAtom(i).getAtomicNumber() > this.container.getAtom(j).getAtomicNumber()) {
            return false;
        }
        return false;
    }

    private int sortClockwise(int[] indices, IAtom focus, IAtom[] atoms, int n) {
        int x = 0;
        for (int j = 1; j < n; ++j) {
            int v = indices[j];
            int i = j - 1;
            while (i >= 0 && NonplanarBonds.less(v, indices[i], atoms, focus.getPoint2d())) {
                indices[i + 1] = indices[i--];
                ++x;
            }
            indices[i + 1] = v;
        }
        return this.parity(x);
    }

    static boolean less(int i, int j, IAtom[] atoms, Point2d center) {
        Point2d a = atoms[i].getPoint2d();
        Point2d b = atoms[j].getPoint2d();
        if (a.x - center.x >= 0.0 && b.x - center.x < 0.0) {
            return true;
        }
        if (a.x - center.x < 0.0 && b.x - center.x >= 0.0) {
            return false;
        }
        if (a.x - center.x == 0.0 && b.x - center.x == 0.0) {
            if (a.y - center.y >= 0.0 || b.y - center.y >= 0.0) {
                return a.y > b.y;
            }
            return b.y > a.y;
        }
        double det = (a.x - center.x) * (b.y - center.y) - (b.x - center.x) * (a.y - center.y);
        if (det < 0.0) {
            return true;
        }
        if (det > 0.0) {
            return false;
        }
        double d1 = (a.x - center.x) * (a.x - center.x) + (a.y - center.y) * (a.y - center.y);
        double d2 = (b.x - center.x) * (b.x - center.x) + (b.y - center.y) * (b.y - center.y);
        return d1 > d2;
    }

    private void labelUnspecified(IBond doubleBond) {
        IBond bond;
        IAtom aBeg = doubleBond.getAtom(0);
        IAtom aEnd = doubleBond.getAtom(1);
        int beg = this.atomToIndex.get(aBeg);
        int end = this.atomToIndex.get(aEnd);
        int nAdj = 0;
        IAtom[] focus = new IAtom[4];
        IAtom[] adj = new IAtom[4];
        for (int neighbor : this.graph[beg]) {
            bond = this.edgeToBond.get(beg, neighbor);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (nAdj == 4) {
                    return;
                }
                focus[nAdj] = aBeg;
                adj[nAdj++] = this.container.getAtom(neighbor);
            }
            if (bond.getStereo() != IBond.Stereo.UP_OR_DOWN && bond.getStereo() != IBond.Stereo.UP_OR_DOWN_INVERTED) continue;
            return;
        }
        for (int neighbor : this.graph[end]) {
            bond = this.edgeToBond.get(end, neighbor);
            if (bond.getOrder() == IBond.Order.SINGLE) {
                if (nAdj == 4) {
                    return;
                }
                focus[nAdj] = aEnd;
                adj[nAdj++] = this.container.getAtom(neighbor);
            }
            if (bond.getStereo() != IBond.Stereo.UP_OR_DOWN && bond.getStereo() != IBond.Stereo.UP_OR_DOWN_INVERTED) continue;
            return;
        }
        int[] rank = this.priority(-1, adj, nAdj);
        for (int i = 0; i < nAdj; ++i) {
            if (this.doubleBondElements[this.atomToIndex.get(adj[rank[i]])] != null || this.tetrahedralElements[this.atomToIndex.get(adj[rank[i]])] != null) continue;
            this.edgeToBond.get(this.atomToIndex.get(focus[rank[i]]), this.atomToIndex.get(adj[rank[i]])).setStereo(IBond.Stereo.UP_OR_DOWN);
            return;
        }
        doubleBond.setStereo(IBond.Stereo.E_OR_Z);
    }

    private List<IBond> findUnspecifiedDoubleBonds(int[][] adjList) {
        ArrayList<IBond> unspecifiedDoubleBonds = new ArrayList<IBond>();
        for (IBond bond : this.container.bonds()) {
            int end;
            if (bond.getOrder() != IBond.Order.DOUBLE) continue;
            IAtom aBeg = bond.getAtom(0);
            IAtom aEnd = bond.getAtom(1);
            int beg = this.atomToIndex.get(aBeg);
            if (this.ringSearch.cyclic(beg, end = this.atomToIndex.get(aEnd).intValue()) || this.doubleBondElements[beg] != null && this.doubleBondElements[beg].getStereoBond() == bond || this.doubleBondElements[end] != null && this.doubleBondElements[end].getStereoBond() == bond || this.tetrahedralElements[beg] != null || this.tetrahedralElements[end] != null || !this.hasOnlyPlainBonds(beg, bond) || !this.hasOnlyPlainBonds(end, bond) || this.hasLinearEqualPaths(adjList, beg, end) || this.hasLinearEqualPaths(adjList, end, beg)) continue;
            unspecifiedDoubleBonds.add(bond);
        }
        return unspecifiedDoubleBonds;
    }

    private boolean hasLinearEqualPaths(int[][] adjList, int start, int prev) {
        int a = -1;
        int b = -1;
        for (int w : adjList[start]) {
            if (w == prev) continue;
            if (a == -1) {
                a = w;
                continue;
            }
            if (b == -1) {
                b = w;
                continue;
            }
            return false;
        }
        if (b < 0) {
            return false;
        }
        HashSet<IAtom> visit = new HashSet<IAtom>();
        IAtom aAtom = this.container.getAtom(a);
        IAtom bAtom = this.container.getAtom(b);
        visit.add(this.container.getAtom(start));
        if (aAtom.isInRing() || bAtom.isInRing()) {
            return false;
        }
        IAtom aNext = aAtom;
        IAtom bNext = bAtom;
        while (aNext != null && bNext != null) {
            IAtom atom;
            aAtom = aNext;
            bAtom = bNext;
            visit.add(aAtom);
            visit.add(bAtom);
            aNext = null;
            bNext = null;
            if (this.notEqual(aAtom.getAtomicNumber(), bAtom.getAtomicNumber())) {
                return false;
            }
            if (this.notEqual(aAtom.getFormalCharge(), bAtom.getFormalCharge())) {
                return false;
            }
            if (this.notEqual(aAtom.getMassNumber(), bAtom.getMassNumber())) {
                return false;
            }
            int hCntA = aAtom.getImplicitHydrogenCount();
            int hCntB = bAtom.getImplicitHydrogenCount();
            int cntA = 0;
            int cntB = 0;
            for (int w : adjList[this.atomToIndex.get(aAtom)]) {
                atom = this.container.getAtom(w);
                if (visit.contains(atom)) continue;
                if (atom.getAtomicNumber() == 1 && adjList[w].length == 1) {
                    ++hCntA;
                    continue;
                }
                aNext = cntA == 0 ? atom : null;
                ++cntA;
            }
            for (int w : adjList[this.atomToIndex.get(bAtom)]) {
                atom = this.container.getAtom(w);
                if (visit.contains(atom)) continue;
                if (atom.getAtomicNumber() == 1 && adjList[w].length == 1) {
                    ++hCntB;
                    continue;
                }
                bNext = cntB == 0 ? atom : null;
                ++cntB;
            }
            if (hCntA != hCntB) {
                return false;
            }
            if (cntA == cntB && (cntA <= 1 || cntB <= 1)) continue;
            return false;
        }
        return aNext == null && bNext == null;
    }

    private boolean notEqual(Integer a, Integer b) {
        return a == null ? b != null : !a.equals(b);
    }

    private boolean hasOnlyPlainBonds(int v, IBond allowedDoubleBond) {
        int count = 0;
        for (int neighbor : this.graph[v]) {
            IBond adjBond = this.edgeToBond.get(v, neighbor);
            if (adjBond.getOrder().numeric() > 1) {
                if (allowedDoubleBond == adjBond) continue;
                return false;
            }
            if (adjBond.getStereo() == IBond.Stereo.UP_OR_DOWN || adjBond.getStereo() == IBond.Stereo.UP_OR_DOWN_INVERTED) {
                return false;
            }
            ++count;
        }
        return count > 0;
    }
}

