/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import com.google.common.primitives.Ints;
import java.util.List;
import org.openscience.cdk.io.formats.IChemFormat;

public interface IChemFormatMatcher
extends IChemFormat {
    public static final MatchResult NO_MATCH = new MatchResult(false, null, Integer.MAX_VALUE);

    public MatchResult matches(List<String> var1);

    public static final class MatchResult
    implements Comparable<MatchResult> {
        private final boolean matched;
        private final int position;
        private final IChemFormat format;

        public MatchResult(boolean matched, IChemFormat format, int position) {
            this.matched = matched;
            this.format = format;
            this.position = position;
        }

        public boolean matched() {
            return this.matched;
        }

        public IChemFormat format() {
            if (!this.matched) {
                throw new IllegalArgumentException("result did not match");
            }
            return this.format;
        }

        @Override
        public int compareTo(MatchResult that) {
            return Ints.compare(this.position, that.position);
        }
    }
}

