/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.openscience.cdk.config.NaturalElement;
import org.openscience.cdk.interfaces.IElement;

public enum Elements {
    Unknown(0, "", 0, 0, null, 0.0, null),
    Hydrogen(1, "H", 1, 1, 0.37, 1.2, 2.2),
    Helium(2, "He", 1, 18, 0.32, 1.4, null),
    Lithium(3, "Li", 2, 1, 1.34, 2.2, 0.98),
    Beryllium(4, "Be", 2, 2, 0.9, 1.9, 1.57),
    Boron(5, "B", 2, 13, 0.82, 1.8, 2.04),
    Carbon(6, "C", 2, 14, 0.77, 1.7, 2.55),
    Nitrogen(7, "N", 2, 15, 0.75, 1.6, 3.04),
    Oxygen(8, "O", 2, 16, 0.73, 1.55, 3.44),
    Fluorine(9, "F", 2, 17, 0.71, 1.5, 3.98),
    Neon(10, "Ne", 2, 18, 0.69, 1.54, null),
    Sodium(11, "Na", 3, 1, 1.54, 2.4, 0.93),
    Magnesium(12, "Mg", 3, 2, 1.3, 2.2, 1.31),
    Aluminium(13, "Al", 3, 13, 1.18, 2.1, 1.61),
    Silicon(14, "Si", 3, 14, 1.11, 2.1, 1.9),
    Phosphorus(15, "P", 3, 15, 1.06, 1.95, 2.19),
    Sulfur(16, "S", 3, 16, 1.02, 1.8, 2.58),
    Chlorine(17, "Cl", 3, 17, 0.99, 1.8, 3.16),
    Argon(18, "Ar", 3, 18, 0.97, 1.88, null),
    Potassium(19, "K", 4, 1, 1.96, 2.8, 0.82),
    Calcium(20, "Ca", 4, 2, 1.74, 2.4, 1.0),
    Scandium(21, "Sc", 4, 3, 1.44, 2.3, 1.36),
    Titanium(22, "Ti", 4, 4, 1.36, 2.15, 1.54),
    Vanadium(23, "V", 4, 5, 1.25, 2.05, 1.63),
    Chromium(24, "Cr", 4, 6, 1.27, 2.05, 1.66),
    Manganese(25, "Mn", 4, 7, 1.39, 2.05, 1.55),
    Iron(26, "Fe", 4, 8, 1.25, 2.05, 1.83),
    Cobalt(27, "Co", 4, 9, 1.26, null, 1.88),
    Nickel(28, "Ni", 4, 10, 1.21, null, 1.91),
    Copper(29, "Cu", 4, 11, 1.38, null, 1.9),
    Zinc(30, "Zn", 4, 12, 1.31, 2.1, 1.65),
    Gallium(31, "Ga", 4, 13, 1.26, 2.1, 1.81),
    Germanium(32, "Ge", 4, 14, 1.22, 2.1, 2.01),
    Arsenic(33, "As", 4, 15, 1.19, 2.05, 2.18),
    Selenium(34, "Se", 4, 16, 1.16, 1.9, 2.55),
    Bromine(35, "Br", 4, 17, 1.14, 1.9, 2.96),
    Krypton(36, "Kr", 4, 18, 1.1, 2.02, 3.0),
    Rubidium(37, "Rb", 5, 1, 2.11, 2.9, 0.82),
    Strontium(38, "Sr", 5, 2, 1.92, 2.55, 0.95),
    Yttrium(39, "Y", 5, 3, 1.62, 2.4, 1.22),
    Zirconium(40, "Zr", 5, 4, 1.48, 2.3, 1.33),
    Niobium(41, "Nb", 5, 5, 1.37, 2.15, 1.6),
    Molybdenum(42, "Mo", 5, 6, 1.45, 2.1, 2.16),
    Technetium(43, "Tc", 5, 7, 1.56, 2.05, 1.9),
    Ruthenium(44, "Ru", 5, 8, 1.26, 2.05, 2.2),
    Rhodium(45, "Rh", 5, 9, 1.35, null, 2.28),
    Palladium(46, "Pd", 5, 10, 1.31, 2.05, 2.2),
    Silver(47, "Ag", 5, 11, 1.53, 2.1, 1.93),
    Cadmium(48, "Cd", 5, 12, 1.48, 2.2, 1.69),
    Indium(49, "In", 5, 13, 1.44, 2.2, 1.78),
    Tin(50, "Sn", 5, 14, 1.41, 2.25, 1.96),
    Antimony(51, "Sb", 5, 15, 1.38, 2.2, 2.05),
    Tellurium(52, "Te", 5, 16, 1.35, 2.1, 2.1),
    Iodine(53, "I", 5, 17, 1.33, 2.1, 2.66),
    Xenon(54, "Xe", 5, 18, 1.3, 2.16, 2.6),
    Caesium(55, "Cs", 6, 1, 2.25, 3.0, 0.79),
    Barium(56, "Ba", 6, 2, 1.98, 2.7, 0.89),
    Lanthanum(57, "La", 6, 3, 1.69, 2.5, 1.1),
    Cerium(58, "Ce", 6, 0, null, 2.48, 1.12),
    Praseodymium(59, "Pr", 6, 0, null, 2.47, 1.13),
    Neodymium(60, "Nd", 6, 0, null, 2.45, 1.14),
    Promethium(61, "Pm", 6, 0, null, 2.43, null),
    Samarium(62, "Sm", 6, 0, null, 2.42, 1.17),
    Europium(63, "Eu", 6, 0, 2.4, 2.4, null),
    Gadolinium(64, "Gd", 6, 0, null, 2.38, 1.2),
    Terbium(65, "Tb", 6, 0, null, 2.37, null),
    Dysprosium(66, "Dy", 6, 0, null, 2.35, 1.22),
    Holmium(67, "Ho", 6, 0, null, 2.33, 1.23),
    Erbium(68, "Er", 6, 0, null, 2.32, 1.24),
    Thulium(69, "Tm", 6, 0, null, 2.3, 1.25),
    Ytterbium(70, "Yb", 6, 0, null, 2.28, null),
    Lutetium(71, "Lu", 6, 0, 1.6, 2.27, 1.27),
    Hafnium(72, "Hf", 6, 4, 1.5, 2.25, 1.3),
    Tantalum(73, "Ta", 6, 5, 1.38, 2.2, 1.5),
    Tungsten(74, "W", 6, 6, 1.46, 2.1, 2.36),
    Rhenium(75, "Re", 6, 7, 1.59, 2.05, 1.9),
    Osmium(76, "Os", 6, 8, 1.28, null, 2.2),
    Iridium(77, "Ir", 6, 9, 1.37, null, 2.2),
    Platinum(78, "Pt", 6, 10, 1.28, 2.05, 2.28),
    Gold(79, "Au", 6, 11, 1.44, 2.1, 2.54),
    Mercury(80, "Hg", 6, 12, 1.49, 2.05, 2.0),
    Thallium(81, "Tl", 6, 13, 1.48, 2.2, 1.62),
    Lead(82, "Pb", 6, 14, 1.47, 2.3, 2.33),
    Bismuth(83, "Bi", 6, 15, 1.46, 2.3, 2.02),
    Polonium(84, "Po", 6, 16, 1.46, null, 2.0),
    Astatine(85, "At", 6, 17, null, null, 2.2),
    Radon(86, "Rn", 6, 18, 1.45, null, null),
    Francium(87, "Fr", 7, 1, null, null, 0.7),
    Radium(88, "Ra", 7, 2, null, null, 0.9),
    Actinium(89, "Ac", 7, 3, null, null, 1.1),
    Thorium(90, "Th", 7, 0, null, 2.4, 1.3),
    Protactinium(91, "Pa", 7, 0, null, null, 1.5),
    Uranium(92, "U", 7, 0, null, 2.3, 1.38),
    Neptunium(93, "Np", 7, 0, null, null, 1.36),
    Plutonium(94, "Pu", 7, 0, null, null, 1.28),
    Americium(95, "Am", 7, 0, null, null, 1.3),
    Curium(96, "Cm", 7, 0, null, null, 1.3),
    Berkelium(97, "Bk", 7, 0, null, null, 1.3),
    Californium(98, "Cf", 7, 0, null, null, 1.3),
    Einsteinium(99, "Es", 7, 0, null, null, 1.3),
    Fermium(100, "Fm", 7, 0, null, null, 1.3),
    Mendelevium(101, "Md", 7, 0, null, null, 1.3),
    Nobelium(102, "No", 7, 0, null, null, 1.3),
    Lawrencium(103, "Lr", 7, 0, null, null, null),
    Rutherfordium(104, "Rf", 7, 4, null, null, null),
    Dubnium(105, "Db", 7, 5, null, null, null),
    Seaborgium(106, "Sg", 7, 6, null, null, null),
    Bohrium(107, "Bh", 7, 7, null, null, null),
    Hassium(108, "Hs", 7, 8, null, null, null),
    Meitnerium(109, "Mt", 7, 9, null, null, null),
    Darmstadtium(110, "Ds", 7, 10, null, null, null),
    Roentgenium(111, "Rg", 7, 11, null, null, null),
    Copernicium(112, "Cn", 7, 12, null, null, null),
    Ununtrium(113, "Uut", 0, 0, null, null, null),
    Flerovium(114, "Fl", 0, 0, null, null, null),
    Ununpentium(115, "Uup", 0, 0, null, null, null),
    Livermorium(116, "Lv", 0, 0, null, null, null),
    Ununseptium(117, "Uus", 0, 0, null, null, null),
    Ununoctium(118, "Uuo", 0, 0, null, null, null);

    private final int number;
    private final int period;
    private final int group;
    private final String symbol;
    private final Double rCov;
    private final Double rW;
    private final Double electronegativity;
    private final IElement instance;
    static final Elements[] NUMER_MAP;
    static final Map<String, Elements> SYMBOL_MAP;
    public static final IElement DUMMY;
    public static final IElement HYDROGEN;
    public static final IElement HELIUM;
    public static final IElement LITHIUM;
    public static final IElement BERYLLIUM;
    public static final IElement BORON;
    public static final IElement CARBON;
    public static final IElement NITROGEN;
    public static final IElement OXYGEN;
    public static final IElement FLUORINE;
    public static final IElement NEON;
    public static final IElement SODIUM;
    public static final IElement MAGNESIUM;
    public static final IElement ALUMINIUM;
    public static final IElement SILICON;
    public static final IElement PHOSPHORUS;
    public static final IElement SULFUR;
    public static final IElement CHLORINE;
    public static final IElement ARGON;
    public static final IElement POTASSIUM;
    public static final IElement CALCIUM;
    public static final IElement SCANDIUM;
    public static final IElement TITANIUM;
    public static final IElement VANADIUM;
    public static final IElement CHROMIUM;
    public static final IElement MANGANESE;
    public static final IElement IRON;
    public static final IElement COBALT;
    public static final IElement NICKEL;
    public static final IElement COPPER;
    public static final IElement ZINC;
    public static final IElement GALLIUM;
    public static final IElement GERMANIUM;
    public static final IElement ARSENIC;
    public static final IElement SELENIUM;
    public static final IElement BROMINE;
    public static final IElement KRYPTON;
    public static final IElement RUBIDIUM;
    public static final IElement STRONTIUM;
    public static final IElement YTTRIUM;
    public static final IElement ZIRCONIUM;
    public static final IElement NIOBIUM;
    public static final IElement MOLYBDENUM;
    public static final IElement TECHNETIUM;
    public static final IElement RUTHENIUM;
    public static final IElement RHODIUM;
    public static final IElement PALLADIUM;
    public static final IElement SILVER;
    public static final IElement CADMIUM;
    public static final IElement INDIUM;
    public static final IElement TIN;
    public static final IElement ANTIMONY;
    public static final IElement TELLURIUM;
    public static final IElement IODINE;
    public static final IElement XENON;
    public static final IElement CAESIUM;
    public static final IElement BARIUM;
    public static final IElement LANTHANUM;
    public static final IElement CERIUM;
    public static final IElement PRASEODYMIUM;
    public static final IElement NEODYMIUM;
    public static final IElement PROMETHIUM;
    public static final IElement SAMARIUM;
    public static final IElement EUROPIUM;
    public static final IElement GADOLINIUM;
    public static final IElement TERBIUM;
    public static final IElement DYSPROSIUM;
    public static final IElement HOLMIUM;
    public static final IElement ERBIUM;
    public static final IElement THULIUM;
    public static final IElement YTTERBIUM;
    public static final IElement LUTETIUM;
    public static final IElement HAFNIUM;
    public static final IElement TANTALUM;
    public static final IElement TUNGSTEN;
    public static final IElement RHENIUM;
    public static final IElement OSMIUM;
    public static final IElement IRIDIUM;
    public static final IElement PLATINUM;
    public static final IElement GOLD;
    public static final IElement MERCURY;
    public static final IElement THALLIUM;
    public static final IElement LEAD;
    public static final IElement BISMUTH;
    public static final IElement POLONIUM;
    public static final IElement ASTATINE;
    public static final IElement RADON;
    public static final IElement FRANCIUM;
    public static final IElement RADIUM;
    public static final IElement ACTINIUM;
    public static final IElement THORIUM;
    public static final IElement PROTACTINIUM;
    public static final IElement URANIUM;
    public static final IElement NEPTUNIUM;
    public static final IElement PLUTONIUM;
    public static final IElement AMERICIUM;
    public static final IElement CURIUM;
    public static final IElement BERKELIUM;
    public static final IElement CALIFORNIUM;
    public static final IElement EINSTEINIUM;
    public static final IElement FERMIUM;
    public static final IElement MENDELEVIUM;
    public static final IElement NOBELIUM;
    public static final IElement LAWRENCIUM;
    public static final IElement RUTHERFORDIUM;
    public static final IElement DUBNIUM;
    public static final IElement SEABORGIUM;
    public static final IElement BOHRIUM;
    public static final IElement HASSIUM;
    public static final IElement MEITNERIUM;
    public static final IElement DARMSTADTIUM;
    public static final IElement ROENTGENIUM;
    public static final IElement UNUNBIUM;
    public static final IElement UNUNTRIUM;
    public static final IElement UNUNQUADIUM;
    public static final IElement FLEROVIUM;
    public static final IElement UNUNPENTIUM;
    public static final IElement UNUNHEXIUM;
    public static final IElement LIVERMORIUM;
    @Deprecated
    public static final IElement PLUTOMNIUM;

    private Elements(int number, String symbol, int period, int group, Double rCov, Double rW, Double electronegativity) {
        this.number = number;
        this.period = period;
        this.group = group;
        this.symbol = symbol;
        this.rCov = rCov;
        this.rW = rW;
        this.electronegativity = electronegativity;
        this.instance = new NaturalElement(symbol, number);
    }

    public int number() {
        return this.number;
    }

    public String symbol() {
        return this.symbol;
    }

    public int period() {
        return this.period;
    }

    public int group() {
        return this.group;
    }

    public Double covalentRadius() {
        return this.rCov;
    }

    public Double vdwRadius() {
        return this.rW;
    }

    public Double electronegativity() {
        return this.electronegativity;
    }

    public IElement toIElement() {
        return this.instance;
    }

    public static Elements ofNumber(int number) {
        if (number < 0 || number > 118) {
            return Unknown;
        }
        return NUMER_MAP[number];
    }

    public static Elements ofString(String str) {
        if (str == null) {
            return Unknown;
        }
        Elements e = SYMBOL_MAP.get(str.toLowerCase(Locale.ENGLISH));
        if (e == null) {
            return Unknown;
        }
        return e;
    }

    static {
        NUMER_MAP = new Elements[119];
        SYMBOL_MAP = new HashMap<String, Elements>(400);
        Elements[] elementsArray = Elements.values();
        int n = elementsArray.length;
        for (int i = 0; i < n; ++i) {
            Elements e;
            Elements.NUMER_MAP[e.number] = e = elementsArray[i];
            SYMBOL_MAP.put(e.symbol.toLowerCase(Locale.ENGLISH), e);
            SYMBOL_MAP.put(e.name().toLowerCase(Locale.ENGLISH), e);
        }
        SYMBOL_MAP.put("uub", Copernicium);
        SYMBOL_MAP.put("ununbium", Copernicium);
        SYMBOL_MAP.put("uuq", Flerovium);
        SYMBOL_MAP.put("ununquadium", Flerovium);
        SYMBOL_MAP.put("uuh", Livermorium);
        SYMBOL_MAP.put("ununhexium", Livermorium);
        SYMBOL_MAP.put("sulphur", Sulfur);
        SYMBOL_MAP.put("cesium", Caesium);
        SYMBOL_MAP.put("aluminum", Aluminium);
        DUMMY = Unknown.toIElement();
        HYDROGEN = Hydrogen.toIElement();
        HELIUM = Helium.toIElement();
        LITHIUM = Lithium.toIElement();
        BERYLLIUM = Beryllium.toIElement();
        BORON = Boron.toIElement();
        CARBON = Carbon.toIElement();
        NITROGEN = Nitrogen.toIElement();
        OXYGEN = Oxygen.toIElement();
        FLUORINE = Fluorine.toIElement();
        NEON = Neon.toIElement();
        SODIUM = Sodium.toIElement();
        MAGNESIUM = Magnesium.toIElement();
        ALUMINIUM = Aluminium.toIElement();
        SILICON = Silicon.toIElement();
        PHOSPHORUS = Phosphorus.toIElement();
        SULFUR = Sulfur.toIElement();
        CHLORINE = Chlorine.toIElement();
        ARGON = Argon.toIElement();
        POTASSIUM = Potassium.toIElement();
        CALCIUM = Calcium.toIElement();
        SCANDIUM = Scandium.toIElement();
        TITANIUM = Titanium.toIElement();
        VANADIUM = Vanadium.toIElement();
        CHROMIUM = Chromium.toIElement();
        MANGANESE = Manganese.toIElement();
        IRON = Iron.toIElement();
        COBALT = Cobalt.toIElement();
        NICKEL = Nickel.toIElement();
        COPPER = Copper.toIElement();
        ZINC = Zinc.toIElement();
        GALLIUM = Gallium.toIElement();
        GERMANIUM = Germanium.toIElement();
        ARSENIC = Arsenic.toIElement();
        SELENIUM = Selenium.toIElement();
        BROMINE = Bromine.toIElement();
        KRYPTON = Krypton.toIElement();
        RUBIDIUM = Rubidium.toIElement();
        STRONTIUM = Strontium.toIElement();
        YTTRIUM = Yttrium.toIElement();
        ZIRCONIUM = Zirconium.toIElement();
        NIOBIUM = Niobium.toIElement();
        MOLYBDENUM = Molybdenum.toIElement();
        TECHNETIUM = Technetium.toIElement();
        RUTHENIUM = Ruthenium.toIElement();
        RHODIUM = Rhodium.toIElement();
        PALLADIUM = Palladium.toIElement();
        SILVER = Silver.toIElement();
        CADMIUM = Cadmium.toIElement();
        INDIUM = Indium.toIElement();
        TIN = Tin.toIElement();
        ANTIMONY = Antimony.toIElement();
        TELLURIUM = Tellurium.toIElement();
        IODINE = Iodine.toIElement();
        XENON = Xenon.toIElement();
        CAESIUM = Caesium.toIElement();
        BARIUM = Barium.toIElement();
        LANTHANUM = Lanthanum.toIElement();
        CERIUM = Cerium.toIElement();
        PRASEODYMIUM = Praseodymium.toIElement();
        NEODYMIUM = Neodymium.toIElement();
        PROMETHIUM = Promethium.toIElement();
        SAMARIUM = Samarium.toIElement();
        EUROPIUM = Europium.toIElement();
        GADOLINIUM = Gadolinium.toIElement();
        TERBIUM = Terbium.toIElement();
        DYSPROSIUM = Dysprosium.toIElement();
        HOLMIUM = Holmium.toIElement();
        ERBIUM = Erbium.toIElement();
        THULIUM = Thulium.toIElement();
        YTTERBIUM = Ytterbium.toIElement();
        LUTETIUM = Lutetium.toIElement();
        HAFNIUM = Hafnium.toIElement();
        TANTALUM = Tantalum.toIElement();
        TUNGSTEN = Tungsten.toIElement();
        RHENIUM = Rhenium.toIElement();
        OSMIUM = Osmium.toIElement();
        IRIDIUM = Iridium.toIElement();
        PLATINUM = Platinum.toIElement();
        GOLD = Gold.toIElement();
        MERCURY = Mercury.toIElement();
        THALLIUM = Thallium.toIElement();
        LEAD = Lead.toIElement();
        BISMUTH = Bismuth.toIElement();
        POLONIUM = Polonium.toIElement();
        ASTATINE = Astatine.toIElement();
        RADON = Radon.toIElement();
        FRANCIUM = Francium.toIElement();
        RADIUM = Radium.toIElement();
        ACTINIUM = Actinium.toIElement();
        THORIUM = Thorium.toIElement();
        PROTACTINIUM = Protactinium.toIElement();
        URANIUM = Uranium.toIElement();
        NEPTUNIUM = Neptunium.toIElement();
        PLUTONIUM = Plutonium.toIElement();
        AMERICIUM = Americium.toIElement();
        CURIUM = Curium.toIElement();
        BERKELIUM = Berkelium.toIElement();
        CALIFORNIUM = Californium.toIElement();
        EINSTEINIUM = Einsteinium.toIElement();
        FERMIUM = Fermium.toIElement();
        MENDELEVIUM = Mendelevium.toIElement();
        NOBELIUM = Nobelium.toIElement();
        LAWRENCIUM = Lawrencium.toIElement();
        RUTHERFORDIUM = Rutherfordium.toIElement();
        DUBNIUM = Dubnium.toIElement();
        SEABORGIUM = Seaborgium.toIElement();
        BOHRIUM = Bohrium.toIElement();
        HASSIUM = Hassium.toIElement();
        MEITNERIUM = Meitnerium.toIElement();
        DARMSTADTIUM = Darmstadtium.toIElement();
        ROENTGENIUM = Roentgenium.toIElement();
        UNUNBIUM = Copernicium.toIElement();
        UNUNTRIUM = Ununtrium.toIElement();
        UNUNQUADIUM = Flerovium.toIElement();
        FLEROVIUM = Flerovium.toIElement();
        UNUNPENTIUM = Ununpentium.toIElement();
        UNUNHEXIUM = Livermorium.toIElement();
        LIVERMORIUM = Livermorium.toIElement();
        PLUTOMNIUM = PLUTONIUM;
    }
}

