/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.debug;

import java.util.Map;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.PseudoAtom;
import org.openscience.cdk.debug.DebugChemObjectBuilder;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemObjectChangeEvent;
import org.openscience.cdk.interfaces.IChemObjectListener;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebugPseudoAtom
extends PseudoAtom
implements IPseudoAtom {
    private static final long serialVersionUID = -5935090219383862070L;
    ILoggingTool logger = LoggingToolFactory.createLoggingTool(DebugPseudoAtom.class);

    public DebugPseudoAtom() {
        this.logger.debug("Instantiated a DebugAtom");
    }

    public DebugPseudoAtom(IElement element) {
        super(element);
        this.logger.debug("Instantiated a DebugAtom: element= ", element);
    }

    public DebugPseudoAtom(String symbol) {
        super(symbol);
        this.logger.debug("Instantiated a DebugAtom: symbol= ", symbol);
    }

    public DebugPseudoAtom(String symbol, Point2d point2d) {
        super(symbol, point2d);
        this.logger.debug("Instantiated a DebugAtom: symbol= ", symbol + " point2d=" + point2d);
    }

    public DebugPseudoAtom(String symbol, Point3d point3d) {
        super(symbol, point3d);
        this.logger.debug("Instantiated a DebugAtom: symbol= ", symbol + " point3d=" + point3d);
    }

    @Override
    public void setCharge(Double charge) {
        this.logger.debug("Setting charge: ", charge);
        super.setCharge(charge);
    }

    @Override
    public Double getCharge() {
        this.logger.debug("Setting charge: ", super.getCharge());
        return super.getCharge();
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.logger.debug("Setting hydrogen count: ", hydrogenCount);
        super.setImplicitHydrogenCount(hydrogenCount);
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        this.logger.debug("Getting hydrogen count: ", super.getImplicitHydrogenCount());
        return super.getImplicitHydrogenCount();
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        this.logger.debug("Setting point2d: x=" + point2d.x + ", y=" + point2d.y);
        super.setPoint2d(point2d);
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        this.logger.debug("Setting point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        super.setPoint3d(point3d);
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        this.logger.debug("Setting fractional point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        super.setFractionalPoint3d(point3d);
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        this.logger.debug("Setting stereoParity: ", stereoParity);
        super.setStereoParity(stereoParity);
    }

    @Override
    public Point2d getPoint2d() {
        Point2d point2d = super.getPoint2d();
        if (point2d == null) {
            this.logger.debug("Getting point2d: null");
        } else {
            this.logger.debug("Getting point2d: x=" + point2d.x + ", y=" + point2d.y);
        }
        return point2d;
    }

    @Override
    public Point3d getPoint3d() {
        Point3d point3d = super.getPoint3d();
        if (point3d == null) {
            this.logger.debug("Getting point3d: null");
        } else {
            this.logger.debug("Getting point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        }
        return point3d;
    }

    @Override
    public Point3d getFractionalPoint3d() {
        Point3d point3d = super.getFractionalPoint3d();
        if (point3d == null) {
            this.logger.debug("Getting fractional point3d: null");
        } else {
            this.logger.debug("Getting fractional point3d: x=" + point3d.x + ", y=" + point3d.y, ", z=" + point3d.z);
        }
        return point3d;
    }

    @Override
    public Integer getStereoParity() {
        this.logger.debug("Getting stereo parity: ", super.getStereoParity());
        return super.getStereoParity();
    }

    @Override
    public void setAtomTypeName(String identifier) {
        this.logger.debug("Setting atom type name: ", identifier);
        super.setAtomTypeName(identifier);
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.logger.debug("Setting max bond order: ", new Object[]{maxBondOrder});
        super.setMaxBondOrder(maxBondOrder);
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        this.logger.debug("Setting bond order sum: ", bondOrderSum);
        super.setBondOrderSum(bondOrderSum);
    }

    @Override
    public String getAtomTypeName() {
        this.logger.debug("Getting atom type name: ", super.getAtomTypeName());
        return super.getAtomTypeName();
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        this.logger.debug("Getting max bond order: ", new Object[]{super.getMaxBondOrder()});
        return super.getMaxBondOrder();
    }

    @Override
    public Double getBondOrderSum() {
        this.logger.debug("Getting bond order sum: ", super.getBondOrderSum());
        return super.getBondOrderSum();
    }

    @Override
    public void setFormalCharge(Integer charge) {
        this.logger.debug("Setting formal charge: ", charge);
        super.setFormalCharge(charge);
    }

    @Override
    public Integer getFormalCharge() {
        this.logger.debug("Getting formal charge: ", super.getFormalCharge());
        return super.getFormalCharge();
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        this.logger.debug("Setting forml neighbour count: ", count);
        super.setFormalNeighbourCount(count);
    }

    @Override
    public Integer getFormalNeighbourCount() {
        this.logger.debug("Getting formal neighbour count: ", super.getFormalNeighbourCount());
        return super.getFormalNeighbourCount();
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.logger.debug("Setting hybridization: ", new Object[]{hybridization});
        super.setHybridization(hybridization);
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        this.logger.debug("Getting hybridization: ", new Object[]{super.getHybridization()});
        return super.getHybridization();
    }

    @Override
    public void setCovalentRadius(Double radius) {
        this.logger.debug("Setting covalent radius: ", radius);
        super.setCovalentRadius(radius);
    }

    @Override
    public Double getCovalentRadius() {
        this.logger.debug("Getting covalent radius: ", super.getCovalentRadius());
        return super.getCovalentRadius();
    }

    @Override
    public void setValency(Integer valency) {
        this.logger.debug("Setting valency: ", valency);
        super.setValency(valency);
    }

    @Override
    public Integer getValency() {
        this.logger.debug("Getting valency: ", super.getValency());
        return super.getValency();
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.logger.debug("Setting natural abundance: ", naturalAbundance);
        super.setNaturalAbundance(naturalAbundance);
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.logger.debug("Setting exact mass: ", exactMass);
        super.setExactMass(exactMass);
    }

    @Override
    public Double getNaturalAbundance() {
        this.logger.debug("Getting natural abundance: ", super.getNaturalAbundance());
        return super.getNaturalAbundance();
    }

    @Override
    public Double getExactMass() {
        this.logger.debug("Getting exact mass: ", super.getExactMass());
        return super.getExactMass();
    }

    @Override
    public Integer getMassNumber() {
        this.logger.debug("Getting mass number: ", super.getMassNumber());
        return super.getMassNumber();
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.logger.debug("Setting mass number: ", massNumber);
        super.setMassNumber(massNumber);
    }

    @Override
    public Integer getAtomicNumber() {
        this.logger.debug("Getting atomic number: ", super.getAtomicNumber());
        return super.getAtomicNumber();
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.logger.debug("Setting atomic number: ", atomicNumber);
        super.setAtomicNumber(atomicNumber);
    }

    @Override
    public String getSymbol() {
        this.logger.debug("Getting symbol: ", super.getSymbol());
        return super.getSymbol();
    }

    @Override
    public void setSymbol(String symbol) {
        this.logger.debug("Setting symbol: ", symbol);
        super.setSymbol(symbol);
    }

    @Override
    public void addListener(IChemObjectListener col) {
        this.logger.debug("Adding listener: ", col);
        super.addListener(col);
    }

    @Override
    public int getListenerCount() {
        this.logger.debug("Getting listener count: ", super.getListenerCount());
        return super.getListenerCount();
    }

    @Override
    public void removeListener(IChemObjectListener col) {
        this.logger.debug("Removing listener: ", col);
        super.removeListener(col);
    }

    @Override
    public void notifyChanged() {
        this.logger.debug("Notifying changed");
        super.notifyChanged();
    }

    @Override
    public void notifyChanged(IChemObjectChangeEvent evt) {
        this.logger.debug("Notifying changed event: ", evt);
        super.notifyChanged(evt);
    }

    @Override
    public void setProperty(Object description, Object property) {
        this.logger.debug("Setting property: ", description + "=" + property);
        super.setProperty(description, property);
    }

    @Override
    public void removeProperty(Object description) {
        this.logger.debug("Removing property: ", description);
        super.removeProperty(description);
    }

    @Override
    public Object getProperty(Object description) {
        this.logger.debug("Getting property: ", description + "=" + super.getProperty(description));
        return super.getProperty(description);
    }

    @Override
    public Map<Object, Object> getProperties() {
        this.logger.debug("Getting properties");
        return super.getProperties();
    }

    @Override
    public String getID() {
        this.logger.debug("Getting ID: ", super.getID());
        return super.getID();
    }

    @Override
    public void setID(String identifier) {
        this.logger.debug("Setting ID: ", identifier);
        super.setID(identifier);
    }

    @Override
    public void setFlag(int flag_type, boolean flag_value) {
        this.logger.debug("Setting flag: ", flag_type + "=" + flag_value);
        super.setFlag(flag_type, flag_value);
    }

    @Override
    public boolean getFlag(int flag_type) {
        this.logger.debug("Setting flag: ", flag_type + "=" + super.getFlag(flag_type));
        return super.getFlag(flag_type);
    }

    @Override
    public void setProperties(Map<Object, Object> properties) {
        this.logger.debug("Setting properties: ", properties);
        super.setProperties(properties);
    }

    @Override
    public void setFlags(boolean[] flagsNew) {
        this.logger.debug("Setting flags:", flagsNew.length);
        super.setFlags(flagsNew);
    }

    @Override
    public boolean[] getFlags() {
        this.logger.debug("Getting flags:", super.getFlags().length);
        return super.getFlags();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        Object clone = null;
        try {
            clone = super.clone();
        }
        catch (Exception exception) {
            this.logger.error("Could not clone DebugAtom: " + exception.getMessage(), exception);
            this.logger.debug(exception);
        }
        return clone;
    }

    @Override
    public IChemObjectBuilder getBuilder() {
        return DebugChemObjectBuilder.getInstance();
    }

    @Override
    public String getLabel() {
        this.logger.debug("Getting label: ", super.getLabel());
        return super.getLabel();
    }

    @Override
    public void setLabel(String label) {
        this.logger.debug("Setting label: ", label);
        super.setLabel(label);
    }
}

