/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.vflib.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.smsd.algorithm.vflib.builder.TargetProperties;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IEdge;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.INode;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IQuery;
import org.openscience.cdk.smsd.algorithm.vflib.interfaces.IState;
import org.openscience.cdk.smsd.algorithm.vflib.map.Match;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.smsd.algorithm.vflib.VFLibTest")
public class VFState
implements IState {
    private List<Match> candidates;
    private IQuery query;
    private TargetProperties target;
    private List<INode> queryPath;
    private List<IAtom> targetPath;
    private Map<INode, IAtom> map;

    public VFState(IQuery query2, TargetProperties target) {
        this.map = new HashMap<INode, IAtom>();
        this.queryPath = new ArrayList<INode>();
        this.targetPath = new ArrayList<IAtom>();
        this.query = query2;
        this.target = target;
        this.candidates = new ArrayList<Match>();
        this.loadRootCandidates();
    }

    private VFState(VFState state, Match match) {
        this.candidates = new ArrayList<Match>();
        this.queryPath = new ArrayList<INode>(state.queryPath);
        this.targetPath = new ArrayList<IAtom>(state.targetPath);
        this.map = state.map;
        this.query = state.query;
        this.target = state.target;
        this.map.put(match.getQueryNode(), match.getTargetAtom());
        this.queryPath.add(match.getQueryNode());
        this.targetPath.add(match.getTargetAtom());
        this.loadCandidates(match);
    }

    @Override
    public void backTrack() {
        if (this.queryPath.isEmpty() || this.isGoal()) {
            this.map.clear();
            return;
        }
        if (this.isHeadMapped()) {
            return;
        }
        this.map.clear();
        for (int i = 0; i < this.queryPath.size() - 1; ++i) {
            this.map.put(this.queryPath.get(i), this.targetPath.get(i));
        }
    }

    @Override
    public Map<INode, IAtom> getMap() {
        return new HashMap<INode, IAtom>(this.map);
    }

    @Override
    public boolean hasNextCandidate() {
        return !this.candidates.isEmpty();
    }

    @Override
    public boolean isDead() {
        return this.query.countNodes() > this.target.getAtomCount();
    }

    @Override
    public boolean isGoal() {
        return this.map.size() == this.query.countNodes();
    }

    @Override
    public boolean isMatchFeasible(Match match) {
        if (this.map.containsKey(match.getQueryNode()) || this.map.containsValue(match.getTargetAtom())) {
            return false;
        }
        if (!this.matchAtoms(match)) {
            return false;
        }
        return this.matchBonds(match);
    }

    @Override
    public Match nextCandidate() {
        return this.candidates.remove(this.candidates.size() - 1);
    }

    @Override
    public IState nextState(Match match) {
        return new VFState(this, match);
    }

    private void loadRootCandidates() {
        for (int i = 0; i < this.query.countNodes(); ++i) {
            for (int j = 0; j < this.target.getAtomCount(); ++j) {
                Match match = new Match(this.query.getNode(i), this.target.getAtom(j));
                this.candidates.add(match);
            }
        }
    }

    private void loadCandidates(Match lastMatch) {
        IAtom atom = lastMatch.getTargetAtom();
        List<IAtom> targetNeighbors = this.target.getNeighbors(atom);
        for (INode q : lastMatch.getQueryNode().neighbors()) {
            for (IAtom t : targetNeighbors) {
                Match match = new Match(q, t);
                if (!this.candidateFeasible(match)) continue;
                this.candidates.add(match);
            }
        }
    }

    private boolean candidateFeasible(Match candidate) {
        for (INode queryAtom : this.map.keySet()) {
            if (!queryAtom.equals(candidate.getQueryNode()) && !this.map.get(queryAtom).equals(candidate.getTargetAtom())) continue;
            return false;
        }
        return true;
    }

    private boolean matchAtoms(Match match) {
        IAtom atom = match.getTargetAtom();
        if (match.getQueryNode().countNeighbors() > this.target.countNeighbors(atom)) {
            return false;
        }
        return match.getQueryNode().getAtomMatcher().matches(this.target, atom);
    }

    private boolean matchBonds(Match match) {
        if (this.queryPath.isEmpty()) {
            return true;
        }
        if (!this.matchBondsToHead(match)) {
            return false;
        }
        for (int i = 0; i < this.queryPath.size() - 1; ++i) {
            IEdge queryBond = this.query.getEdge(this.queryPath.get(i), match.getQueryNode());
            IBond targetBond = this.target.getBond(this.targetPath.get(i), match.getTargetAtom());
            if (queryBond == null) continue;
            if (targetBond == null) {
                return false;
            }
            if (this.matchBond(queryBond, targetBond)) continue;
            return false;
        }
        return true;
    }

    private boolean matchBond(IEdge edge, IBond targetBond) {
        return edge.getBondMatcher().matches(this.target, targetBond);
    }

    private boolean isHeadMapped() {
        INode head = this.queryPath.get(this.queryPath.size() - 1);
        for (INode neighbor : head.neighbors()) {
            if (this.map.containsKey(neighbor)) continue;
            return false;
        }
        return true;
    }

    private boolean matchBondsToHead(Match match) {
        INode queryHead = this.getQueryPathHead();
        IAtom targetHead = this.getTargetPathHead();
        IEdge queryBond = this.query.getEdge(queryHead, match.getQueryNode());
        IBond targetBond = this.target.getBond(targetHead, match.getTargetAtom());
        if (queryBond == null || targetBond == null) {
            return false;
        }
        return this.matchBond(queryBond, targetBond);
    }

    private INode getQueryPathHead() {
        return this.queryPath.get(this.queryPath.size() - 1);
    }

    private IAtom getTargetPathHead() {
        return this.targetPath.get(this.targetPath.size() - 1);
    }
}

