/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IElement;
import org.openscience.cdk.interfaces.IIsotope;
import org.openscience.cdk.interfaces.IMolecularFormula;

@TestClass(value="org.openscience.cdk.formula.MolecularFormulaManipulatorTest")
public class MolecularFormulaManipulator {
    @TestMethod(value="testGetAtomCount_IMolecularFormula")
    public static int getAtomCount(IMolecularFormula formula) {
        int count = 0;
        for (IIsotope isotope : formula.isotopes()) {
            count += formula.getIsotopeCount(isotope);
        }
        return count;
    }

    @TestMethod(value="testGetElementCount_IMolecularFormula_IElement")
    public static int getElementCount(IMolecularFormula formula, IElement element) {
        int count = 0;
        for (IIsotope isotope : formula.isotopes()) {
            if (!isotope.getSymbol().equals(element.getSymbol())) continue;
            count += formula.getIsotopeCount(isotope);
        }
        return count;
    }

    @TestMethod(value="testGetIsotopes_IMolecularFormula_IElement")
    public static List<IIsotope> getIsotopes(IMolecularFormula formula, IElement element) {
        ArrayList<IIsotope> isotopeList = new ArrayList<IIsotope>();
        for (IIsotope isotope : formula.isotopes()) {
            if (!isotope.getSymbol().equals(element.getSymbol())) continue;
            isotopeList.add(isotope);
        }
        return isotopeList;
    }

    @TestMethod(value="testElements_IMolecularFormula")
    public static List<IElement> elements(IMolecularFormula formula) {
        ArrayList<IElement> elementList = new ArrayList<IElement>();
        ArrayList<String> stringList = new ArrayList<String>();
        for (IIsotope isotope : formula.isotopes()) {
            if (stringList.contains(isotope.getSymbol())) continue;
            elementList.add(isotope);
            stringList.add(isotope.getSymbol());
        }
        return elementList;
    }

    @TestMethod(value="testContainsElement_IMolecularFormula_IElement")
    public static boolean containsElement(IMolecularFormula formula, IElement element) {
        for (IIsotope isotope : formula.isotopes()) {
            if (!element.getSymbol().equals(isotope.getSymbol())) continue;
            return true;
        }
        return false;
    }

    @TestMethod(value="testRemoveElement_IMolecularFormula_IElement")
    public static IMolecularFormula removeElement(IMolecularFormula formula, IElement element) {
        for (IIsotope isotope : MolecularFormulaManipulator.getIsotopes(formula, element)) {
            formula.removeIsotope(isotope);
        }
        return formula;
    }

    @TestMethod(value="testGetString_IMolecularFormula_arrayString_boolean")
    public static String getString(IMolecularFormula formula, String[] orderElements, boolean setOne) {
        StringBuffer stringMF = new StringBuffer();
        List<IIsotope> isotopesList = MolecularFormulaManipulator.putInOrder(orderElements, formula);
        ArrayList<String> elemSet = new ArrayList<String>();
        for (IIsotope isotope : isotopesList) {
            String symbol = isotope.getSymbol();
            if (elemSet.contains(symbol)) continue;
            elemSet.add(symbol);
        }
        for (String elem : elemSet) {
            int count = 0;
            for (IIsotope isotope : formula.isotopes()) {
                if (!isotope.getSymbol().equals(elem)) continue;
                count += formula.getIsotopeCount(isotope);
            }
            stringMF.append(elem);
            if (count == 1 && !setOne) continue;
            stringMF.append(count);
        }
        return stringMF.toString();
    }

    @TestMethod(value="testGetString_IMolecularFormula")
    public static String getString(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getString(formula, false);
    }

    @TestMethod(value="testGetString_IMolecularFormula_boolean")
    public static String getString(IMolecularFormula formula, boolean setOne) {
        if (MolecularFormulaManipulator.containsElement(formula, formula.getBuilder().newInstance(IElement.class, "C"))) {
            return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_WithCarbons(), setOne);
        }
        return MolecularFormulaManipulator.getString(formula, MolecularFormulaManipulator.generateOrderEle_Hill_NoCarbons(), setOne);
    }

    public static List<IIsotope> putInOrder(String[] orderElements, IMolecularFormula formula) {
        ArrayList<IIsotope> isotopesList = new ArrayList<IIsotope>();
        for (String orderElement : orderElements) {
            IElement element = formula.getBuilder().newInstance(IElement.class, orderElement);
            if (!MolecularFormulaManipulator.containsElement(formula, element)) continue;
            List<IIsotope> isotopes = MolecularFormulaManipulator.getIsotopes(formula, element);
            for (IIsotope isotope : isotopes) {
                isotopesList.add(isotope);
            }
        }
        return isotopesList;
    }

    @TestMethod(value="testGetHillString_IMolecularFormula")
    public static String getHillString(IMolecularFormula formula) {
        StringBuffer hillString = new StringBuffer();
        TreeMap<String, Integer> hillMap = new TreeMap<String, Integer>();
        for (IIsotope isotope : formula.isotopes()) {
            String symbol = isotope.getSymbol();
            if (hillMap.containsKey(symbol)) {
                hillMap.put(symbol, (Integer)hillMap.get(symbol) + formula.getIsotopeCount(isotope));
                continue;
            }
            hillMap.put(symbol, formula.getIsotopeCount(isotope));
        }
        if (hillMap.containsKey("C")) {
            hillString.append("C");
            int count = (Integer)hillMap.get("C");
            if (count > 1) {
                hillString.append(count);
            }
            hillMap.remove("C");
            if (hillMap.containsKey("H")) {
                hillString.append("H");
                count = (Integer)hillMap.get("H");
                if (count > 1) {
                    hillString.append(count);
                }
                hillMap.remove("H");
            }
        }
        for (String key : hillMap.keySet()) {
            hillString.append(key);
            int count = (Integer)hillMap.get(key);
            if (count <= 1) continue;
            hillString.append(count);
        }
        return hillString.toString();
    }

    @TestMethod(value="testGetHTML_IMolecularFormula")
    public static String getHTML(IMolecularFormula formula) {
        return MolecularFormulaManipulator.getHTML(formula, false, false);
    }

    @TestMethod(value="testGetHTML_IMolecularFormula_boolean_boolean")
    public static String getHTML(IMolecularFormula formula, boolean chargeB, boolean isotopeB) {
        String[] orderElements;
        String htmlString = "";
        for (String orderElement : orderElements = MolecularFormulaManipulator.generateOrderEle()) {
            IElement element = formula.getBuilder().newInstance(IElement.class, orderElement);
            if (!MolecularFormulaManipulator.containsElement(formula, element)) continue;
            if (!isotopeB) {
                String eleToAdd = element.getSymbol() + "<sub>" + MolecularFormulaManipulator.getElementCount(formula, element) + "</sub>";
                htmlString = htmlString + eleToAdd;
                continue;
            }
            for (IIsotope isotope : MolecularFormulaManipulator.getIsotopes(formula, element)) {
                String isoToAdd = "<sup>" + isotope.getMassNumber() + "</sup>" + isotope.getSymbol() + "<sub>" + formula.getIsotopeCount(isotope) + "</sub>";
                htmlString = htmlString + isoToAdd;
            }
        }
        if (chargeB) {
            Integer charge = formula.getCharge();
            if (charge == CDKConstants.UNSET || charge == 0) {
                return htmlString;
            }
            if (charge < 0) {
                return htmlString + "<sup>" + charge * -1 + "-" + "</sup>";
            }
            return htmlString + "<sup>" + charge + "+" + "</sup>";
        }
        return htmlString;
    }

    @TestMethod(value="testGetMolecularFormula_String_IChemObjectBuilder")
    public static IMolecularFormula getMolecularFormula(String stringMF, IChemObjectBuilder builder) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, false, builder);
    }

    @TestMethod(value="testGetMajorIsotopeMolecularFormula_String_IChemObjectBuilder")
    public static IMolecularFormula getMajorIsotopeMolecularFormula(String stringMF, IChemObjectBuilder builder) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, true, builder);
    }

    private static IMolecularFormula getMolecularFormula(String stringMF, boolean assumeMajorIsotope, IChemObjectBuilder builder) {
        IMolecularFormula formula = builder.newInstance(IMolecularFormula.class, new Object[0]);
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, formula, assumeMajorIsotope);
    }

    @TestMethod(value="testGetMolecularFormula_String_IMolecularFormula")
    public static IMolecularFormula getMolecularFormula(String stringMF, IMolecularFormula formula) {
        return MolecularFormulaManipulator.getMolecularFormula(stringMF, formula, false);
    }

    private static IMolecularFormula getMolecularFormula(String stringMF, IMolecularFormula formula, boolean assumeMajorIsotope) {
        if (stringMF.contains(".") || stringMF.contains("(") || stringMF.charAt(0) >= '0' && stringMF.charAt(0) <= '9') {
            stringMF = MolecularFormulaManipulator.simplifyMolecularFormula(stringMF);
        }
        Integer charge = null;
        if (stringMF.contains("[") && stringMF.contains("]") && (stringMF.contains("+") || stringMF.contains("-"))) {
            charge = MolecularFormulaManipulator.extractCharge(stringMF);
            stringMF = MolecularFormulaManipulator.cleanMFfromCharge(stringMF);
        }
        String RecentElementSymbol = new String();
        String RecentElementCountString = new String("0");
        if (stringMF.length() == 0) {
            return null;
        }
        for (int f = 0; f < stringMF.length(); ++f) {
            char ThisChar = stringMF.charAt(f);
            if (f < stringMF.length()) {
                if (ThisChar >= 'A' && ThisChar <= 'Z') {
                    RecentElementSymbol = String.valueOf(ThisChar);
                    RecentElementCountString = "0";
                }
                if (ThisChar >= 'a' && ThisChar <= 'z') {
                    RecentElementSymbol = RecentElementSymbol + ThisChar;
                }
                if (ThisChar >= '0' && ThisChar <= '9') {
                    RecentElementCountString = RecentElementCountString + ThisChar;
                }
            }
            if (f != stringMF.length() - 1 && (stringMF.charAt(f + 1) < 'A' || stringMF.charAt(f + 1) > 'Z')) continue;
            int RecentElementCount = Integer.valueOf(RecentElementCountString);
            if (RecentElementCount == 0) {
                RecentElementCount = 1;
            }
            IIsotope isotope = formula.getBuilder().newInstance(IIsotope.class, RecentElementSymbol);
            if (assumeMajorIsotope) {
                try {
                    isotope = IsotopeFactory.getInstance(isotope.getBuilder()).getMajorIsotope(RecentElementSymbol);
                }
                catch (IOException e) {
                    throw new RuntimeException("Cannot load the IsotopeFactory");
                }
            }
            formula.addIsotope(isotope, RecentElementCount);
        }
        if (charge != null) {
            formula.setCharge(charge);
        }
        return formula;
    }

    private static String cleanMFfromCharge(String formula) {
        if (!formula.contains("[") || !formula.contains("]")) {
            return formula;
        }
        boolean startBreak = false;
        String finalFormula = "";
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (thisChar == '[') {
                startBreak = true;
                continue;
            }
            if (thisChar == ']') break;
            if (!startBreak) continue;
            finalFormula = finalFormula + thisChar;
        }
        return finalFormula;
    }

    private static int extractCharge(String formula) {
        if (!formula.contains("[") || !formula.contains("]") || !formula.contains("+") && !formula.contains("-")) {
            return 0;
        }
        boolean finishBreak = false;
        String multiple = "";
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (thisChar == ']') {
                finishBreak = true;
                continue;
            }
            if (thisChar == '-') {
                multiple = thisChar + multiple;
                break;
            }
            if (thisChar == '+') break;
            if (!finishBreak) continue;
            multiple = multiple + thisChar;
        }
        if (multiple.equals("") || multiple.equals("-")) {
            multiple = multiple + 1;
        }
        return new Integer(multiple);
    }

    @TestMethod(value="testGetTotalExactMass_IMolecularFormula")
    public static double getTotalExactMass(IMolecularFormula formula) {
        Double mass = 0.0;
        IChemObjectBuilder builder = formula.getBuilder();
        for (IIsotope isotope : formula.isotopes()) {
            if (isotope.getExactMass() == CDKConstants.UNSET) {
                try {
                    mass = mass + IsotopeFactory.getInstance(builder).getMajorIsotope(isotope.getSymbol()).getExactMass() * (double)formula.getIsotopeCount(isotope);
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not instantiate the IsotopeFactory.");
                }
            }
            mass = mass + isotope.getExactMass() * (double)formula.getIsotopeCount(isotope);
        }
        if (formula.getCharge() != null) {
            mass = MolecularFormulaManipulator.correctMass(mass, formula.getCharge());
        }
        return mass;
    }

    private static double correctMass(double mass, Integer charge) {
        double massE = 5.4857990927E-4;
        if (charge > 0) {
            mass -= massE * (double)charge.intValue();
        } else if (charge < 0) {
            mass += massE * (double)Math.abs(charge);
        }
        return mass;
    }

    @TestMethod(value="testGetTotalMassNumber_IMolecularFormula")
    public static double getTotalMassNumber(IMolecularFormula formula) {
        double mass = 0.0;
        for (IIsotope isotope : formula.isotopes()) {
            try {
                IIsotope isotope2 = IsotopeFactory.getInstance(formula.getBuilder()).getMajorIsotope(isotope.getSymbol());
                mass += (double)(isotope2.getMassNumber() * formula.getIsotopeCount(isotope));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return mass;
    }

    @TestMethod(value="testGetNaturalExactMass_IMolecularFormula")
    public static double getNaturalExactMass(IMolecularFormula formula) {
        IsotopeFactory factory;
        double mass = 0.0;
        try {
            factory = IsotopeFactory.getInstance(formula.getBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate the IsotopeFactory.");
        }
        for (IIsotope isotope : formula.isotopes()) {
            IElement isotopesElement = isotope.getBuilder().newInstance(IElement.class, isotope);
            mass += factory.getNaturalMass(isotopesElement) * (double)formula.getIsotopeCount(isotope);
        }
        return mass;
    }

    @TestMethod(value="testGetMajorIsotopeMass_IMolecularFormula")
    public static double getMajorIsotopeMass(IMolecularFormula formula) {
        IsotopeFactory factory;
        double mass = 0.0;
        try {
            factory = IsotopeFactory.getInstance(formula.getBuilder());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not instantiate the IsotopeFactory.");
        }
        for (IIsotope isotope : formula.isotopes()) {
            IIsotope major = factory.getMajorIsotope(isotope.getSymbol());
            mass += major.getExactMass() * (double)formula.getIsotopeCount(isotope);
        }
        return mass;
    }

    @TestMethod(value="testGetTotalNaturalAbundance_IMolecularFormula")
    public static double getTotalNaturalAbundance(IMolecularFormula formula) {
        double abundance = 1.0;
        for (IIsotope isotope : formula.isotopes()) {
            if (isotope.getNaturalAbundance() == null) {
                return 0.0;
            }
            abundance *= Math.pow(isotope.getNaturalAbundance(), formula.getIsotopeCount(isotope));
        }
        return abundance / Math.pow(100.0, MolecularFormulaManipulator.getAtomCount(formula));
    }

    @TestMethod(value="testGetDBE_IMolecularFormula")
    public static double getDBE(IMolecularFormula formula) throws CDKException {
        int[] valencies = new int[5];
        IAtomContainer ac = MolecularFormulaManipulator.getAtomContainer(formula);
        AtomTypeFactory factory = AtomTypeFactory.getInstance("org/openscience/cdk/config/data/structgen_atomtypes.xml", ac.getBuilder());
        for (int f = 0; f < ac.getAtomCount(); ++f) {
            IAtomType[] types = factory.getAtomTypes(ac.getAtom(f).getSymbol());
            if (types.length == 0) {
                throw new CDKException("Calculation of double bond equivalents not possible due to problems with element " + ac.getAtom(f).getSymbol());
            }
            int n = types[0].getBondOrderSum().intValue();
            valencies[n] = valencies[n] + 1;
        }
        return 1 + valencies[4] + valencies[3] / 2 - valencies[1] / 2;
    }

    @TestMethod(value="testGetMolecularFormula_IAtomContainer")
    public static IMolecularFormula getMolecularFormula(IAtomContainer atomContainer) {
        IMolecularFormula formula = atomContainer.getBuilder().newInstance(IMolecularFormula.class, new Object[0]);
        return MolecularFormulaManipulator.getMolecularFormula(atomContainer, formula);
    }

    @TestMethod(value="testGetMolecularFormula_IAtomContainer_IMolecularFormula")
    public static IMolecularFormula getMolecularFormula(IAtomContainer atomContainer, IMolecularFormula formula) {
        int charge = 0;
        for (IAtom iAtom : atomContainer.atoms()) {
            formula.addIsotope(iAtom);
            charge += iAtom.getFormalCharge().intValue();
        }
        formula.setCharge(charge);
        return formula;
    }

    @TestMethod(value="testGetAtomContainer_IMolecularFormula")
    public static IAtomContainer getAtomContainer(IMolecularFormula formula) {
        IAtomContainer atomContainer = formula.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        return MolecularFormulaManipulator.getAtomContainer(formula, atomContainer);
    }

    @TestMethod(value="testGetAtomContainer_IMolecularFormula_IAtomContainer")
    public static IAtomContainer getAtomContainer(IMolecularFormula formula, IAtomContainer atomContainer) {
        for (IIsotope isotope : formula.isotopes()) {
            int occur = formula.getIsotopeCount(isotope);
            for (int i = 0; i < occur; ++i) {
                atomContainer.addAtom(formula.getBuilder().newInstance(IAtom.class, isotope));
            }
        }
        return atomContainer;
    }

    public static String[] generateOrderEle() {
        return new String[]{"C", "H", "O", "N", "Si", "P", "S", "F", "Cl", "Br", "I", "Sn", "B", "Pb", "Tl", "Ba", "In", "Pd", "Pt", "Os", "Ag", "Zr", "Se", "Zn", "Cu", "Ni", "Co", "Fe", "Cr", "Ti", "Ca", "K", "Al", "Mg", "Na", "Ce", "Hg", "Au", "Ir", "Re", "W", "Ta", "Hf", "Lu", "Yb", "Tm", "Er", "Ho", "Dy", "Tb", "Gd", "Eu", "Sm", "Pm", "Nd", "Pr", "La", "Cs", "Xe", "Te", "Sb", "Cd", "Rh", "Ru", "Tc", "Mo", "Nb", "Y", "Sr", "Rb", "Kr", "As", "Ge", "Ga", "Mn", "V", "Sc", "Ar", "Ne", "He", "Be", "Li", "Bi", "Po", "At", "Rn", "Fr", "Ra", "Ac", "Th", "Pa", "U", "Np", "Pu", "Am", "Cm", "Bk", "Cf", "Es", "Fm", "Md", "No", "Lr", "Rf", "Db", "Sg", "Bh", "Hs", "Mt", "Ds", "Rg", "Cn", "R"};
    }

    private static String[] generateOrderEle_Hill_NoCarbons() {
        return new String[]{"Ac", "Ag", "Al", "Am", "Ar", "As", "At", "Au", "B", "Ba", "Be", "Bh", "Bi", "Bk", "Br", "C", "Ca", "Cd", "Ce", "Cf", "Cl", "Cm", "Cn", "Co", "Cr", "Cs", "Cu", "Db", "Ds", "Dy", "Er", "Es", "Eu", "F", "Fe", "Fm", "Fr", "Ga", "Gd", "Ge", "H", "He", "Hf", "Hg", "Ho", "Hs", "I", "In", "Ir", "K", "Kr", "La", "Li", "Lr", "Lu", "Md", "Mg", "Mn", "Mo", "Mt", "N", "Na", "Nb", "Nd", "Ne", "Ni", "No", "Np", "O", "Os", "P", "Pa", "Pb", "Pd", "Pm", "Po", "Pr", "Pt", "Pu", "Ra", "Rb", "Re", "Rf", "Rg", "Rh", "Rn", "Ru", "S", "Sb", "Sc", "Se", "Sg", "Si", "Sm", "Sn", "Sr", "Ta", "Tb", "Tc", "Te", "Th", "Ti", "Tl", "Tm", "U", "V", "W", "Xe", "Y", "Yb", "Zn", "Zr", "R"};
    }

    private static String[] generateOrderEle_Hill_WithCarbons() {
        return new String[]{"C", "H", "Ac", "Ag", "Al", "Am", "Ar", "As", "At", "Au", "B", "Ba", "Be", "Bh", "Bi", "Bk", "Br", "Ca", "Cd", "Ce", "Cf", "Cl", "Cm", "Cn", "Co", "Cr", "Cs", "Cu", "Db", "Ds", "Dy", "Er", "Es", "Eu", "F", "Fe", "Fm", "Fr", "Ga", "Gd", "Ge", "He", "Hf", "Hg", "Ho", "Hs", "I", "In", "Ir", "K", "Kr", "La", "Li", "Lr", "Lu", "Md", "Mg", "Mn", "Mo", "Mt", "N", "Na", "Nb", "Nd", "Ne", "Ni", "No", "Np", "O", "Os", "P", "Pa", "Pb", "Pd", "Pm", "Po", "Pr", "Pt", "Pu", "Ra", "Rb", "Re", "Rf", "Rg", "Rh", "Rn", "Ru", "S", "Sb", "Sc", "Se", "Sg", "Si", "Sm", "Sn", "Sr", "Ta", "Tb", "Tc", "Te", "Th", "Ti", "Tl", "Tm", "U", "V", "W", "Xe", "Y", "Yb", "Zn", "Zr", "R"};
    }

    @TestMethod(value="testCompare_IMolecularFormula_IMolecularFormula")
    public static boolean compare(IMolecularFormula formula1, IMolecularFormula formula2) {
        if (formula1.getCharge() != formula2.getCharge()) {
            return false;
        }
        if (formula1.getIsotopeCount() != formula2.getIsotopeCount()) {
            return false;
        }
        for (IIsotope isotope : formula1.isotopes()) {
            if (!formula2.contains(isotope)) {
                return false;
            }
            if (formula1.getIsotopeCount(isotope) == formula2.getIsotopeCount(isotope)) continue;
            return false;
        }
        for (IIsotope isotope : formula2.isotopes()) {
            if (!formula1.contains(isotope)) {
                return false;
            }
            if (formula2.getIsotopeCount(isotope) == formula1.getIsotopeCount(isotope)) continue;
            return false;
        }
        return true;
    }

    @TestMethod(value="testGetHeavyElements_IMolecularFormula")
    public static List<IElement> getHeavyElements(IMolecularFormula formula) {
        ArrayList<IElement> newEle = new ArrayList<IElement>();
        for (IElement element : MolecularFormulaManipulator.elements(formula)) {
            if (element.getSymbol().equals("H")) continue;
            newEle.add(element);
        }
        return newEle;
    }

    @TestMethod(value="testSimplifyMolecularFormula_String")
    public static String simplifyMolecularFormula(String formula) {
        String newFormula = formula;
        if (formula.contains(" ")) {
            newFormula = newFormula.replace(" ", "");
        }
        if (!formula.contains(".")) {
            return MolecularFormulaManipulator.breakExtractor(formula);
        }
        ArrayList<String> listMF = new ArrayList<String>();
        while (newFormula.contains(".")) {
            int pos = newFormula.indexOf(".");
            String thisFormula = newFormula.substring(0, pos);
            if (thisFormula.charAt(0) >= '0' && thisFormula.charAt(0) <= '9') {
                thisFormula = MolecularFormulaManipulator.multipleExtractor(thisFormula);
            }
            if (thisFormula.contains("(")) {
                thisFormula = MolecularFormulaManipulator.breakExtractor(thisFormula);
            }
            listMF.add(thisFormula);
            thisFormula = newFormula.substring(pos + 1, newFormula.length());
            if (!thisFormula.contains(".")) {
                if (thisFormula.charAt(0) >= '0' && thisFormula.charAt(0) <= '9') {
                    thisFormula = MolecularFormulaManipulator.multipleExtractor(thisFormula);
                }
                if (thisFormula.contains("(")) {
                    thisFormula = MolecularFormulaManipulator.breakExtractor(thisFormula);
                }
                listMF.add(thisFormula);
            }
            newFormula = thisFormula;
        }
        if (newFormula.contains("(")) {
            newFormula = MolecularFormulaManipulator.breakExtractor(newFormula);
        }
        String recentElementSymbol = new String();
        String recentElementCountString = new String("0");
        ArrayList<String> eleSymb = new ArrayList<String>();
        ArrayList<Integer> eleCount = new ArrayList<Integer>();
        for (int i = 0; i < listMF.size(); ++i) {
            String thisFormula = (String)listMF.get(i);
            for (int f = 0; f < thisFormula.length(); ++f) {
                int countA;
                char thisChar = thisFormula.charAt(f);
                if (f < thisFormula.length()) {
                    if (thisChar >= 'A' && thisChar <= 'Z') {
                        recentElementSymbol = String.valueOf(thisChar);
                        recentElementCountString = "0";
                    }
                    if (thisChar >= 'a' && thisChar <= 'z') {
                        recentElementSymbol = recentElementSymbol + thisChar;
                    }
                    if (thisChar >= '0' && thisChar <= '9') {
                        recentElementCountString = recentElementCountString + thisChar;
                    }
                }
                if (f != thisFormula.length() - 1 && (thisFormula.charAt(f + 1) < 'A' || thisFormula.charAt(f + 1) > 'Z')) continue;
                int posit = eleSymb.indexOf(recentElementSymbol);
                int count = Integer.valueOf(recentElementCountString);
                if (posit == -1) {
                    eleSymb.add(recentElementSymbol);
                    eleCount.add(count);
                    continue;
                }
                int countP = Integer.valueOf(recentElementCountString);
                if (countP == 0) {
                    countP = 1;
                }
                if ((countA = ((Integer)eleCount.get(posit)).intValue()) == 0) {
                    countA = 1;
                }
                int value = countP + countA;
                eleCount.remove(posit);
                eleCount.add(posit, value);
            }
        }
        String newF = new String();
        for (int i = 0; i < eleCount.size(); ++i) {
            String element = (String)eleSymb.get(i);
            int num = (Integer)eleCount.get(i);
            newF = num == 0 ? newF + element : newF + element + num;
        }
        return newF;
    }

    private static String breakExtractor(String formula) {
        boolean finalBreak = false;
        String recentformula = new String();
        String multiple = new String("0");
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (thisChar == '(') continue;
            if (thisChar == ')') {
                finalBreak = true;
                continue;
            }
            if (!finalBreak) {
                recentformula = recentformula + thisChar;
                continue;
            }
            multiple = multiple + thisChar;
        }
        String finalformula = MolecularFormulaManipulator.muliplier(recentformula, Integer.valueOf(multiple));
        return finalformula;
    }

    private static String multipleExtractor(String formula) {
        String recentCompoundCount = new String("0");
        String recentCompound = new String();
        boolean found = false;
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (thisChar >= '0' && thisChar <= '9') {
                if (!found) {
                    recentCompoundCount = recentCompoundCount + thisChar;
                    continue;
                }
                recentCompound = recentCompound + thisChar;
                continue;
            }
            found = true;
            recentCompound = recentCompound + thisChar;
        }
        return MolecularFormulaManipulator.muliplier(recentCompound, Integer.valueOf(recentCompoundCount));
    }

    private static String muliplier(String formula, int factor) {
        String finalformula = new String();
        String recentElementSymbol = new String();
        String recentElementCountString = new String("0");
        for (int f = 0; f < formula.length(); ++f) {
            char thisChar = formula.charAt(f);
            if (f < formula.length()) {
                if (thisChar >= 'A' && thisChar <= 'Z') {
                    recentElementSymbol = String.valueOf(thisChar);
                    recentElementCountString = "0";
                }
                if (thisChar >= 'a' && thisChar <= 'z') {
                    recentElementSymbol = recentElementSymbol + thisChar;
                }
                if (thisChar >= '0' && thisChar <= '9') {
                    recentElementCountString = recentElementCountString + thisChar;
                }
            }
            if (f != formula.length() - 1 && (formula.charAt(f + 1) < 'A' || formula.charAt(f + 1) > 'Z')) continue;
            Integer recentElementCount = Integer.valueOf(recentElementCountString);
            finalformula = recentElementCount == 0 ? finalformula + recentElementSymbol + factor : finalformula + recentElementSymbol + recentElementCount * factor;
        }
        return finalformula;
    }
}

