/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.color;

import java.awt.Color;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.renderer.color.IAtomColorer;

@TestClass(value="org.openscience.cdk.renderer.color.CPKAtomColorsTest")
public class CPKAtomColors
implements IAtomColorer,
Serializable {
    private static final long serialVersionUID = -3205785984391537452L;
    private static final Color LIGHT_GREY = new Color(0xC8C8C8);
    private static final Color SKY_BLUE = new Color(0x8F8FFF);
    private static final Color RED = new Color(0xF00000);
    private static final Color YELLOW = new Color(16762930);
    private static final Color WHITE = new Color(0xFFFFFF);
    private static final Color PINK = new Color(16761035);
    private static final Color GOLDEN_ROD = new Color(14329120);
    private static final Color BLUE = new Color(255);
    private static final Color ORANGE = new Color(16753920);
    private static final Color DARK_GREY = new Color(0x808090);
    private static final Color BROWN = new Color(0xA52A2A);
    private static final Color PURPLE = new Color(10494192);
    private static final Color DEEP_PINK = new Color(16716947);
    private static final Color GREEN = new Color(65280);
    private static final Color FIRE_BRICK = new Color(0xB22222);
    private static final Color FOREST_GREEN = new Color(0x228B22);
    private static final Map<Integer, Color> ATOM_COLORS_MASSNUM = new HashMap<Integer, Color>();
    private static final Map<String, Color> ATOM_COLORS_SYMBOL = new HashMap<String, Color>();

    @TestMethod(value="testGetAtomColor")
    public Color getAtomColor(IAtom atom) {
        return this.getAtomColor(atom, DEEP_PINK);
    }

    @TestMethod(value="testGetDefaultAtomColor")
    public Color getAtomColor(IAtom atom, Color defaultColor) {
        Color color = defaultColor;
        String symbol = atom.getSymbol().toUpperCase();
        if (atom.getAtomicNumber() != null && ATOM_COLORS_MASSNUM.containsKey(atom.getAtomicNumber())) {
            color = ATOM_COLORS_MASSNUM.get(atom.getAtomicNumber());
        } else if (ATOM_COLORS_SYMBOL.containsKey(symbol)) {
            color = ATOM_COLORS_SYMBOL.get(symbol);
        }
        return new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    static {
        ATOM_COLORS_SYMBOL.put("H", WHITE);
        ATOM_COLORS_SYMBOL.put("HE", PINK);
        ATOM_COLORS_SYMBOL.put("LI", FIRE_BRICK);
        ATOM_COLORS_SYMBOL.put("B", GREEN);
        ATOM_COLORS_SYMBOL.put("C", LIGHT_GREY);
        ATOM_COLORS_SYMBOL.put("N", SKY_BLUE);
        ATOM_COLORS_SYMBOL.put("O", RED);
        ATOM_COLORS_SYMBOL.put("F", GOLDEN_ROD);
        ATOM_COLORS_SYMBOL.put("NA", BLUE);
        ATOM_COLORS_SYMBOL.put("MG", FOREST_GREEN);
        ATOM_COLORS_SYMBOL.put("AL", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("SI", GOLDEN_ROD);
        ATOM_COLORS_SYMBOL.put("P", ORANGE);
        ATOM_COLORS_SYMBOL.put("S", YELLOW);
        ATOM_COLORS_SYMBOL.put("CL", GREEN);
        ATOM_COLORS_SYMBOL.put("CA", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("TI", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("CR", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("MN", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("FE", ORANGE);
        ATOM_COLORS_SYMBOL.put("NI", BROWN);
        ATOM_COLORS_SYMBOL.put("CU", BROWN);
        ATOM_COLORS_SYMBOL.put("ZN", BROWN);
        ATOM_COLORS_SYMBOL.put("BR", BROWN);
        ATOM_COLORS_SYMBOL.put("AG", DARK_GREY);
        ATOM_COLORS_SYMBOL.put("I", PURPLE);
        ATOM_COLORS_SYMBOL.put("BA", ORANGE);
        ATOM_COLORS_SYMBOL.put("AU", GOLDEN_ROD);
        ATOM_COLORS_MASSNUM.put(1, ATOM_COLORS_SYMBOL.get("H"));
        ATOM_COLORS_MASSNUM.put(2, ATOM_COLORS_SYMBOL.get("HE"));
        ATOM_COLORS_MASSNUM.put(3, ATOM_COLORS_SYMBOL.get("LI"));
        ATOM_COLORS_MASSNUM.put(5, ATOM_COLORS_SYMBOL.get("B"));
        ATOM_COLORS_MASSNUM.put(6, ATOM_COLORS_SYMBOL.get("C"));
        ATOM_COLORS_MASSNUM.put(7, ATOM_COLORS_SYMBOL.get("N"));
        ATOM_COLORS_MASSNUM.put(8, ATOM_COLORS_SYMBOL.get("O"));
        ATOM_COLORS_MASSNUM.put(9, ATOM_COLORS_SYMBOL.get("F"));
        ATOM_COLORS_MASSNUM.put(11, ATOM_COLORS_SYMBOL.get("NA"));
        ATOM_COLORS_MASSNUM.put(12, ATOM_COLORS_SYMBOL.get("MG"));
        ATOM_COLORS_MASSNUM.put(13, ATOM_COLORS_SYMBOL.get("AL"));
        ATOM_COLORS_MASSNUM.put(14, ATOM_COLORS_SYMBOL.get("SI"));
        ATOM_COLORS_MASSNUM.put(15, ATOM_COLORS_SYMBOL.get("P"));
        ATOM_COLORS_MASSNUM.put(16, ATOM_COLORS_SYMBOL.get("S"));
        ATOM_COLORS_MASSNUM.put(17, ATOM_COLORS_SYMBOL.get("CL"));
        ATOM_COLORS_MASSNUM.put(20, ATOM_COLORS_SYMBOL.get("CA"));
        ATOM_COLORS_MASSNUM.put(22, ATOM_COLORS_SYMBOL.get("TI"));
        ATOM_COLORS_MASSNUM.put(24, ATOM_COLORS_SYMBOL.get("CR"));
        ATOM_COLORS_MASSNUM.put(25, ATOM_COLORS_SYMBOL.get("MN"));
        ATOM_COLORS_MASSNUM.put(26, ATOM_COLORS_SYMBOL.get("FE"));
        ATOM_COLORS_MASSNUM.put(28, ATOM_COLORS_SYMBOL.get("NI"));
        ATOM_COLORS_MASSNUM.put(29, ATOM_COLORS_SYMBOL.get("CU"));
        ATOM_COLORS_MASSNUM.put(30, ATOM_COLORS_SYMBOL.get("ZN"));
        ATOM_COLORS_MASSNUM.put(35, ATOM_COLORS_SYMBOL.get("BR"));
        ATOM_COLORS_MASSNUM.put(47, ATOM_COLORS_SYMBOL.get("AG"));
        ATOM_COLORS_MASSNUM.put(53, ATOM_COLORS_SYMBOL.get("I"));
        ATOM_COLORS_MASSNUM.put(56, ATOM_COLORS_SYMBOL.get("BA"));
        ATOM_COLORS_MASSNUM.put(79, ATOM_COLORS_SYMBOL.get("AU"));
    }
}

