/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;

@TestClass(value="org.openscience.cdk.io.formats.CMLFormatTest")
public class CMLFormat
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    private CMLFormat() {
    }

    @TestMethod(value="testResourceFormatSet")
    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new CMLFormat();
        }
        return myself;
    }

    @TestMethod(value="testGetFormatName")
    public String getFormatName() {
        return "Chemical Markup Language";
    }

    @TestMethod(value="testGetMIMEType")
    public String getMIMEType() {
        return "chemical/x-cml";
    }

    @TestMethod(value="testGetPreferredNameExtension")
    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    @TestMethod(value="testGetNameExtensions")
    public String[] getNameExtensions() {
        return new String[]{"cml", "xml"};
    }

    @TestMethod(value="testGetReaderClassName")
    public String getReaderClassName() {
        return "org.openscience.cdk.io.CMLReader";
    }

    @TestMethod(value="testGetWriterClassName")
    public String getWriterClassName() {
        return "org.openscience.cdk.io.CMLWriter";
    }

    public boolean matches(int lineNumber, String line) {
        return line.indexOf("http://www.xml-cml.org/schema") != -1 || line.indexOf("<atom") != -1 || line.indexOf("<molecule") != -1 || line.indexOf("<reaction") != -1 || line.indexOf("<cml") != -1 || line.indexOf("<bond") != -1;
    }

    @TestMethod(value="testIsXMLBased")
    public boolean isXMLBased() {
        return true;
    }

    @TestMethod(value="testGetSupportedDataFeatures")
    public int getSupportedDataFeatures() {
        return 955;
    }

    @TestMethod(value="testGetRequiredDataFeatures")
    public int getRequiredDataFeatures() {
        return 0;
    }
}

