/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.inchi;

import java.util.HashMap;
import java.util.List;
import net.sf.jniinchi.INCHI_BOND_STEREO;
import net.sf.jniinchi.INCHI_BOND_TYPE;
import net.sf.jniinchi.INCHI_PARITY;
import net.sf.jniinchi.INCHI_RET;
import net.sf.jniinchi.INCHI_STEREOTYPE;
import net.sf.jniinchi.JniInchiAtom;
import net.sf.jniinchi.JniInchiBond;
import net.sf.jniinchi.JniInchiException;
import net.sf.jniinchi.JniInchiInputInchi;
import net.sf.jniinchi.JniInchiOutputStructure;
import net.sf.jniinchi.JniInchiStereo0D;
import net.sf.jniinchi.JniInchiWrapper;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomParity;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.inchi.InChIToStructureTest")
public class InChIToStructure {
    protected JniInchiInputInchi input;
    protected JniInchiOutputStructure output;
    protected IAtomContainer molecule;

    @TestMethod(value="testConstructor_String_IChemObjectBuilder")
    protected InChIToStructure(String inchi, IChemObjectBuilder builder) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, "");
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, String options) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, options);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected InChIToStructure(String inchi, IChemObjectBuilder builder, List<String> options) throws CDKException {
        try {
            this.input = new JniInchiInputInchi(inchi, options);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage());
        }
        this.generateAtomContainerFromInchi(builder);
    }

    protected void generateAtomContainerFromInchi(IChemObjectBuilder builder) throws CDKException {
        int i;
        try {
            this.output = JniInchiWrapper.getStructureFromInchi(this.input);
        }
        catch (JniInchiException jie) {
            throw new CDKException("Failed to convert InChI to molecule: " + jie.getMessage(), jie);
        }
        this.molecule = builder.newInstance(IAtomContainer.class, new Object[0]);
        HashMap<JniInchiAtom, IAtom> inchiCdkAtomMap = new HashMap<JniInchiAtom, IAtom>();
        for (i = 0; i < this.output.getNumAtoms(); ++i) {
            int numH;
            JniInchiAtom iAt = this.output.getAtom(i);
            IAtom cAt = builder.newInstance(IAtom.class, new Object[0]);
            inchiCdkAtomMap.put(iAt, cAt);
            cAt.setID("a" + i);
            cAt.setSymbol(iAt.getElementType());
            int charge = iAt.getCharge();
            if (charge != 0) {
                cAt.setFormalCharge(charge);
            }
            if ((numH = iAt.getImplicitH()) != 0) {
                cAt.setImplicitHydrogenCount(numH);
            }
            this.molecule.addAtom(cAt);
        }
        for (i = 0; i < this.output.getNumBonds(); ++i) {
            JniInchiBond iBo = this.output.getBond(i);
            IBond cBo = builder.newInstance(IBond.class, new Object[0]);
            IAtom atO = (IAtom)inchiCdkAtomMap.get(iBo.getOriginAtom());
            IAtom atT = (IAtom)inchiCdkAtomMap.get(iBo.getTargetAtom());
            IAtom[] atoms = new IAtom[]{atO, atT};
            cBo.setAtoms(atoms);
            INCHI_BOND_TYPE type = iBo.getBondType();
            if (type == INCHI_BOND_TYPE.SINGLE) {
                cBo.setOrder(CDKConstants.BONDORDER_SINGLE);
            } else if (type == INCHI_BOND_TYPE.DOUBLE) {
                cBo.setOrder(CDKConstants.BONDORDER_DOUBLE);
            } else if (type == INCHI_BOND_TYPE.TRIPLE) {
                cBo.setOrder(CDKConstants.BONDORDER_TRIPLE);
            } else if (type == INCHI_BOND_TYPE.ALTERN) {
                cBo.setFlag(5, true);
            } else {
                throw new CDKException("Unknown bond type: " + (Object)((Object)type));
            }
            INCHI_BOND_STEREO stereo = iBo.getBondStereo();
            if (stereo == INCHI_BOND_STEREO.NONE) {
                cBo.setStereo(IBond.Stereo.NONE);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1DOWN) {
                cBo.setStereo(IBond.Stereo.DOWN);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1UP) {
                cBo.setStereo(IBond.Stereo.UP);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_2DOWN) {
                cBo.setStereo(IBond.Stereo.DOWN_INVERTED);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_2UP) {
                cBo.setStereo(IBond.Stereo.UP_INVERTED);
            } else if (stereo == INCHI_BOND_STEREO.SINGLE_1EITHER || stereo == INCHI_BOND_STEREO.DOUBLE_EITHER) {
                cBo.setStereo((IBond.Stereo)((Object)CDKConstants.UNSET));
            }
            this.molecule.addBond(cBo);
        }
        for (i = 0; i < this.output.getNumStereo0D(); ++i) {
            int sign;
            JniInchiStereo0D stereo0d = this.output.getStereo0D(i);
            if (stereo0d.getStereoType() != INCHI_STEREOTYPE.TETRAHEDRAL) continue;
            JniInchiAtom central = stereo0d.getCentralAtom();
            JniInchiAtom[] neighbours = stereo0d.getNeighbors();
            IAtom atC = (IAtom)inchiCdkAtomMap.get(central);
            IAtom at0 = (IAtom)inchiCdkAtomMap.get(neighbours[0]);
            IAtom at1 = (IAtom)inchiCdkAtomMap.get(neighbours[1]);
            IAtom at2 = (IAtom)inchiCdkAtomMap.get(neighbours[2]);
            IAtom at3 = (IAtom)inchiCdkAtomMap.get(neighbours[3]);
            if (stereo0d.getParity() == INCHI_PARITY.ODD) {
                sign = -1;
            } else {
                if (stereo0d.getParity() != INCHI_PARITY.EVEN) continue;
                sign = 1;
            }
            IAtomParity parity = builder.newInstance(IAtomParity.class, atC, at0, at1, at2, at3, sign);
            this.molecule.addStereoElement(parity);
        }
    }

    @TestMethod(value="testGetAtomContainer")
    public IAtomContainer getAtomContainer() {
        return this.molecule;
    }

    @TestMethod(value="testGetReturnStatus_EOF")
    public INCHI_RET getReturnStatus() {
        return this.output.getReturnStatus();
    }

    public String getMessage() {
        return this.output.getMessage();
    }

    public String getLog() {
        return this.output.getLog();
    }

    public long[][] getWarningFlags() {
        return this.output.getWarningFlags();
    }
}

